/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.collect.Iterables;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.PendingFile;

public class StreamRequest {
    public static final IVersionedSerializer<StreamRequest> serializer = new StreamRequestSerializer();
    protected final long sessionId;
    protected final InetAddress target;
    protected final PendingFile file;
    protected final Collection<Range<Token>> ranges;
    protected final String table;
    protected final Iterable<ColumnFamilyStore> columnFamilies;
    protected final OperationType type;

    StreamRequest(InetAddress target, Collection<Range<Token>> ranges, String table, Iterable<ColumnFamilyStore> columnFamilies, long sessionId, OperationType type) {
        this.target = target;
        this.ranges = ranges;
        this.table = table;
        this.columnFamilies = columnFamilies;
        this.sessionId = sessionId;
        this.type = type;
        this.file = null;
    }

    StreamRequest(InetAddress target, PendingFile file, long sessionId) {
        this.target = target;
        this.file = file;
        this.sessionId = sessionId;
        this.type = file.type;
        this.ranges = null;
        this.table = null;
        this.columnFamilies = null;
    }

    public MessageOut<StreamRequest> createMessage() {
        return new MessageOut<StreamRequest>(MessagingService.Verb.STREAM_REQUEST, this, serializer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        if (this.file == null) {
            sb.append(this.table);
            sb.append("@");
            sb.append(this.columnFamilies.toString());
            sb.append("@");
            sb.append(this.target);
            sb.append("------->");
            for (Range<Token> range : this.ranges) {
                sb.append(range);
                sb.append(" ");
            }
            sb.append((Object)this.type);
        } else {
            sb.append(this.file.toString());
        }
        return sb.toString();
    }

    private static class StreamRequestSerializer
    implements IVersionedSerializer<StreamRequest> {
        private StreamRequestSerializer() {
        }

        @Override
        public void serialize(StreamRequest srm, DataOutput dos, int version) throws IOException {
            dos.writeLong(srm.sessionId);
            CompactEndpointSerializationHelper.serialize(srm.target, dos);
            if (srm.file != null) {
                dos.writeBoolean(true);
                PendingFile.serializer.serialize(srm.file, dos, version);
            } else {
                dos.writeBoolean(false);
                dos.writeUTF(srm.table);
                dos.writeInt(srm.ranges.size());
                for (Range<Token> range : srm.ranges) {
                    AbstractBounds.serializer.serialize((AbstractBounds<?>)range, dos, version);
                }
                dos.writeUTF(srm.type.name());
                dos.writeInt(Iterables.size(srm.columnFamilies));
                for (ColumnFamilyStore cfs : srm.columnFamilies) {
                    ColumnFamily.serializer.serializeCfId(cfs.metadata.cfId, dos, version);
                }
            }
        }

        @Override
        public StreamRequest deserialize(DataInput dis, int version) throws IOException {
            long sessionId = dis.readLong();
            InetAddress target = CompactEndpointSerializationHelper.deserialize(dis);
            boolean singleFile = dis.readBoolean();
            if (singleFile) {
                PendingFile file = PendingFile.serializer.deserialize(dis, version);
                return new StreamRequest(target, file, sessionId);
            }
            String table = dis.readUTF();
            int size = dis.readInt();
            ArrayList<Range<Token>> ranges = size == 0 ? null : new ArrayList<Range<Token>>(size);
            for (int i = 0; i < size; ++i) {
                ranges.add((Range)((AbstractBounds)AbstractBounds.serializer.deserialize(dis, version)).toTokenBounds());
            }
            OperationType type = OperationType.RESTORE_REPLICA_COUNT;
            type = OperationType.valueOf(dis.readUTF());
            ArrayList<ColumnFamilyStore> stores = new ArrayList<ColumnFamilyStore>();
            int cfsSize = dis.readInt();
            for (int i = 0; i < cfsSize; ++i) {
                stores.add(Table.open(table).getColumnFamilyStore(ColumnFamily.serializer.deserializeCfId(dis, version)));
            }
            return new StreamRequest(target, ranges, table, stores, sessionId, type);
        }

        @Override
        public long serializedSize(StreamRequest sr, int version) {
            long size = TypeSizes.NATIVE.sizeof(sr.sessionId);
            size += (long)CompactEndpointSerializationHelper.serializedSize(sr.target);
            size += (long)TypeSizes.NATIVE.sizeof(true);
            if (sr.file != null) {
                return size + PendingFile.serializer.serializedSize(sr.file, version);
            }
            size += (long)TypeSizes.NATIVE.sizeof(sr.table);
            size += (long)TypeSizes.NATIVE.sizeof(sr.ranges.size());
            for (Range<Token> range : sr.ranges) {
                size += AbstractBounds.serializer.serializedSize((AbstractBounds<?>)range, version);
            }
            size += (long)TypeSizes.NATIVE.sizeof(sr.type.name());
            size += (long)TypeSizes.NATIVE.sizeof(Iterables.size(sr.columnFamilies));
            for (ColumnFamilyStore cfs : sr.columnFamilies) {
                size += (long)ColumnFamily.serializer.cfIdSerializedSize(cfs.metadata.cfId, TypeSizes.NATIVE, version);
            }
            return size;
        }
    }
}

