/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.PropertyFileSnitch;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipingPropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(GossipingPropertyFileSnitch.class);
    public static final String RACKDC_PROPERTY_FILENAME = "cassandra-rackdc.properties";
    private PropertyFileSnitch psnitch;
    private String myDC;
    private String myRack;

    public GossipingPropertyFileSnitch() throws ConfigurationException {
        try {
            this.loadConfiguration();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Unable to load cassandra-rackdc.properties : ", e);
        }
        try {
            this.psnitch = new PropertyFileSnitch();
            logger.info("Loaded cassandra-topology.properties for compatibility");
        }
        catch (ConfigurationException e) {
            logger.info("Unable to load cassandra-topology.properties; compatibility mode disabled");
        }
    }

    private void loadConfiguration() throws ConfigurationException {
        InputStream stream = GossipingPropertyFileSnitch.class.getClassLoader().getResourceAsStream(RACKDC_PROPERTY_FILENAME);
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to read cassandra-rackdc.properties", e);
        }
        finally {
            FileUtils.closeQuietly(stream);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("dc")) {
                this.myDC = value;
                continue;
            }
            if (!key.equals("rack")) continue;
            this.myRack = value;
        }
        if (this.myDC == null || this.myRack == null) {
            throw new ConfigurationException("DC or rack not found in cassandra-rackdc.properties");
        }
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.DC) == null) {
            if (this.psnitch == null) {
                throw new RuntimeException("Could not retrieve DC for " + endpoint + " from gossip and PFS compatibility is disabled");
            }
            return this.psnitch.getDatacenter(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    @Override
    public String getRack(InetAddress endpoint) {
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.RACK) == null) {
            if (this.psnitch == null) {
                throw new RuntimeException("Could not retrieve rack for " + endpoint + " from gossip and PFS compatibility is disabled");
            }
            return this.psnitch.getRack(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public void gossiperStarting() {
        logger.info("Adding ApplicationState DC=" + this.myDC + " rack=" + this.myRack);
        Gossiper.instance.addLocalApplicationState(ApplicationState.DC, StorageService.instance.valueFactory.datacenter(this.myDC));
        Gossiper.instance.addLocalApplicationState(ApplicationState.RACK, StorageService.instance.valueFactory.rack(this.myRack));
    }
}

