/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.BigLongArray;
import org.apache.cassandra.utils.Pair;

public class CompressionMetadata {
    public final long dataLength;
    public final long compressedFileLength;
    private final BigLongArray chunkOffsets;
    public final String indexFilePath;
    public final CompressionParameters parameters;

    public static CompressionMetadata create(String dataFilePath) {
        Descriptor desc = Descriptor.fromFilename(dataFilePath);
        return new CompressionMetadata(desc.filenameFor(Component.COMPRESSION_INFO), new File(dataFilePath).length());
    }

    CompressionMetadata(String indexFilePath, long compressedLength) {
        DataInputStream stream;
        this.indexFilePath = indexFilePath;
        try {
            stream = new DataInputStream(new FileInputStream(indexFilePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            String compressorName = stream.readUTF();
            int optionCount = stream.readInt();
            HashMap<String, String> options = new HashMap<String, String>();
            for (int i = 0; i < optionCount; ++i) {
                String key = stream.readUTF();
                String value = stream.readUTF();
                options.put(key, value);
            }
            int chunkLength = stream.readInt();
            try {
                this.parameters = new CompressionParameters(compressorName, (Integer)chunkLength, options);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Cannot create CompressionParameters for stored parameters", e);
            }
            this.dataLength = stream.readLong();
            this.compressedFileLength = compressedLength;
            this.chunkOffsets = this.readChunkOffsets(stream);
        }
        catch (IOException e) {
            throw new CorruptSSTableException((Exception)e, indexFilePath);
        }
        finally {
            FileUtils.closeQuietly(stream);
        }
    }

    public ICompressor compressor() {
        return this.parameters.sstableCompressor;
    }

    public int chunkLength() {
        return this.parameters.chunkLength();
    }

    private BigLongArray readChunkOffsets(DataInput input) {
        try {
            int chunkCount = input.readInt();
            BigLongArray offsets = new BigLongArray(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                try {
                    offsets.set(i, input.readLong());
                    continue;
                }
                catch (EOFException e) {
                    String msg = String.format("Corrupted Index File %s: read %d but expected %d chunks.", this.indexFilePath, i, chunkCount);
                    throw new CorruptSSTableException((Exception)new IOException(msg, e), this.indexFilePath);
                }
            }
            return offsets;
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.indexFilePath);
        }
    }

    public Chunk chunkFor(long position) {
        int idx = (int)(position / (long)this.parameters.chunkLength());
        if (idx >= this.chunkOffsets.size) {
            throw new CorruptSSTableException((Exception)new EOFException(), this.indexFilePath);
        }
        long chunkOffset = this.chunkOffsets.get(idx);
        long nextChunkOffset = idx + 1 == this.chunkOffsets.size ? this.compressedFileLength : this.chunkOffsets.get(idx + 1);
        return new Chunk(chunkOffset, (int)(nextChunkOffset - chunkOffset - 4L));
    }

    public Chunk[] getChunksForSections(Collection<Pair<Long, Long>> sections) {
        TreeSet<Chunk> offsets = new TreeSet<Chunk>(new Comparator<Chunk>(){

            @Override
            public int compare(Chunk o1, Chunk o2) {
                return Longs.compare((long)o1.offset, (long)o2.offset);
            }
        });
        for (Pair<Long, Long> section : sections) {
            int startIndex = (int)((Long)section.left / (long)this.parameters.chunkLength());
            int endIndex = (int)((Long)section.right / (long)this.parameters.chunkLength());
            for (int i = startIndex; i <= endIndex; ++i) {
                long chunkOffset = this.chunkOffsets.get(i);
                long nextChunkOffset = i + 1 == this.chunkOffsets.size ? this.compressedFileLength : this.chunkOffsets.get(i + 1);
                offsets.add(new Chunk(chunkOffset, (int)(nextChunkOffset - chunkOffset - 4L)));
            }
        }
        return offsets.toArray(new Chunk[offsets.size()]);
    }

    static class ChunkSerializer
    implements IVersionedSerializer<Chunk> {
        ChunkSerializer() {
        }

        @Override
        public void serialize(Chunk chunk, DataOutput out, int version) throws IOException {
            out.writeLong(chunk.offset);
            out.writeInt(chunk.length);
        }

        @Override
        public Chunk deserialize(DataInput in, int version) throws IOException {
            return new Chunk(in.readLong(), in.readInt());
        }

        @Override
        public long serializedSize(Chunk chunk, int version) {
            long size = TypeSizes.NATIVE.sizeof(chunk.offset);
            return size += (long)TypeSizes.NATIVE.sizeof(chunk.length);
        }
    }

    public static class Chunk {
        public static final IVersionedSerializer<Chunk> serializer = new ChunkSerializer();
        public final long offset;
        public final int length;

        public Chunk(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Chunk chunk = (Chunk)o;
            return this.length == chunk.length && this.offset == chunk.offset;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.length;
            return result;
        }

        public String toString() {
            return String.format("Chunk<offset: %d, length: %d>", this.offset, this.length);
        }
    }

    public static class Writer
    extends RandomAccessFile {
        private long dataLengthOffset = -1L;
        private final String filePath;

        private Writer(String path) throws FileNotFoundException {
            super(path, "rw");
            this.filePath = path;
        }

        public static Writer open(String path) {
            try {
                return new Writer(path);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void writeHeader(CompressionParameters parameters) {
            try {
                this.writeUTF(parameters.sstableCompressor.getClass().getSimpleName());
                this.writeInt(parameters.otherOptions.size());
                for (Map.Entry<String, String> entry : parameters.otherOptions.entrySet()) {
                    this.writeUTF(entry.getKey());
                    this.writeUTF(entry.getValue());
                }
                this.writeInt(parameters.chunkLength());
                this.dataLengthOffset = this.getFilePointer();
                this.writeLong(-1L);
                this.writeInt(-1);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.filePath);
            }
        }

        public void finalizeHeader(long dataLength, int chunks) {
            long currentPosition;
            assert (this.dataLengthOffset != -1L) : "writeHeader wasn't called";
            try {
                currentPosition = this.getFilePointer();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, this.filePath);
            }
            try {
                this.seek(this.dataLengthOffset);
                this.writeLong(dataLength);
                this.writeInt(chunks);
                this.seek(currentPosition);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.filePath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long chunkOffsetBy(int chunkIndex) {
            long l;
            if (this.dataLengthOffset == -1L) {
                throw new IllegalStateException("writeHeader wasn't called");
            }
            long position = this.getFilePointer();
            this.seek(this.dataLengthOffset + 8L + 4L + (long)chunkIndex * 8L);
            try {
                l = this.readLong();
            }
            catch (Throwable throwable) {
                try {
                    this.seek(position);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FSReadError((Throwable)e, this.filePath);
                }
            }
            this.seek(position);
            return l;
        }

        public void resetAndTruncate(int chunkIndex) {
            try {
                this.seek(this.dataLengthOffset + 8L + 4L + (long)chunkIndex * 8L);
                this.getChannel().truncate(this.getFilePointer());
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.filePath);
            }
        }
    }
}

