/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.cassandra.hadoop.ColumnFamilyRecordWriter;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.Progressable;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyOutputFormat
extends OutputFormat<ByteBuffer, List<Mutation>>
implements org.apache.hadoop.mapred.OutputFormat<ByteBuffer, List<Mutation>> {
    public static final String BATCH_THRESHOLD = "mapreduce.output.columnfamilyoutputformat.batch.threshold";
    public static final String QUEUE_SIZE = "mapreduce.output.columnfamilyoutputformat.queue.size";
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyOutputFormat.class);

    public void checkOutputSpecs(JobContext context) {
        this.checkOutputSpecs(context.getConfiguration());
    }

    private void checkOutputSpecs(Configuration conf) {
        if (ConfigHelper.getOutputKeyspace(conf) == null || ConfigHelper.getOutputColumnFamily(conf) == null) {
            throw new UnsupportedOperationException("you must set the keyspace and columnfamily with setColumnFamily()");
        }
        if (ConfigHelper.getOutputPartitioner(conf) == null) {
            throw new UnsupportedOperationException("You must set the output partitioner to the one used by your Cassandra cluster");
        }
        if (ConfigHelper.getOutputInitialAddress(conf) == null) {
            throw new UnsupportedOperationException("You must set the initial output address to a Cassandra node");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    @Deprecated
    public void checkOutputSpecs(FileSystem filesystem, JobConf job) throws IOException {
        this.checkOutputSpecs((Configuration)job);
    }

    @Deprecated
    public ColumnFamilyRecordWriter getRecordWriter(FileSystem filesystem, JobConf job, String name, org.apache.hadoop.util.Progressable progress) throws IOException {
        return new ColumnFamilyRecordWriter((Configuration)job, new Progressable(progress));
    }

    public ColumnFamilyRecordWriter getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new ColumnFamilyRecordWriter(context);
    }

    public static Cassandra.Client createAuthenticatedClient(TSocket socket, Configuration conf) throws InvalidRequestException, TException, AuthenticationException, AuthorizationException, LoginException {
        logger.debug("Creating authenticated client for CF output format");
        TTransport transport = ConfigHelper.getOutputTransportFactory(conf).openTransport(socket);
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport);
        Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
        client.set_keyspace(ConfigHelper.getOutputKeyspace(conf));
        if (ConfigHelper.getOutputKeyspaceUserName(conf) != null) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("username", ConfigHelper.getOutputKeyspaceUserName(conf));
            creds.put("password", ConfigHelper.getOutputKeyspacePassword(conf));
            AuthenticationRequest authRequest = new AuthenticationRequest(creds);
            client.login(authRequest);
        }
        logger.debug("Authenticated client for CF output format created successfully");
        return client;
    }

    public static class NullOutputCommitter
    extends OutputCommitter {
        public void abortTask(TaskAttemptContext taskContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }
    }
}

