/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.columniterator.ISSTableColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;

public interface IFilter {
    public OnDiskAtomIterator getMemtableColumnIterator(ColumnFamily var1, DecoratedKey var2);

    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader var1, FileDataInput var2, DecoratedKey var3, RowIndexEntry var4);

    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader var1, DecoratedKey var2);

    public void collectReducedColumns(IColumnContainer var1, Iterator<IColumn> var2, int var3);

    public SuperColumn filterSuperColumn(SuperColumn var1, int var2);

    public Comparator<IColumn> getColumnComparator(AbstractType<?> var1);

    public boolean isReversed();

    public void updateColumnsLimit(int var1);

    public static class Serializer
    implements IVersionedSerializer<IFilter> {
        public static Serializer instance = new Serializer();

        @Override
        public void serialize(IFilter filter, DataOutput dos, int version) throws IOException {
            if (filter instanceof SliceQueryFilter) {
                dos.writeByte(0);
                SliceQueryFilter.serializer.serialize((SliceQueryFilter)filter, dos, version);
            } else {
                dos.writeByte(1);
                NamesQueryFilter.serializer.serialize((NamesQueryFilter)filter, dos, version);
            }
        }

        @Override
        public IFilter deserialize(DataInput dis, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        public IFilter deserialize(DataInput dis, int version, AbstractType<?> comparator) throws IOException {
            byte type = dis.readByte();
            if (type == 0) {
                return SliceQueryFilter.serializer.deserialize(dis, version);
            }
            assert (type == 1);
            return NamesQueryFilter.serializer.deserialize(dis, version, comparator);
        }

        @Override
        public long serializedSize(IFilter filter, int version) {
            int size = 1;
            size = filter instanceof SliceQueryFilter ? (int)((long)size + SliceQueryFilter.serializer.serializedSize((SliceQueryFilter)filter, version)) : (int)((long)size + NamesQueryFilter.serializer.serializedSize((NamesQueryFilter)filter, version));
            return size;
        }
    }
}

