/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.HeapAllocator;

public class PrecompactedRow
extends AbstractCompactedRow {
    private final ColumnFamily compactedCf;
    private ColumnIndex columnIndex;

    public PrecompactedRow(DecoratedKey key, ColumnFamily cf) {
        super(key);
        this.compactedCf = cf;
    }

    public static ColumnFamily removeDeletedAndOldShards(DecoratedKey key, CompactionController controller, ColumnFamily cf) {
        ColumnFamily compacted;
        assert (key != null);
        assert (controller != null);
        assert (cf != null);
        Boolean shouldPurge = null;
        if (cf.hasIrrelevantData(controller.gcBefore)) {
            shouldPurge = controller.shouldPurge(key);
        }
        if ((compacted = ColumnFamilyStore.removeDeleted(cf, shouldPurge != null && shouldPurge != false ? controller.gcBefore : Integer.MIN_VALUE)) != null && compacted.metadata().getDefaultValidator().isCommutative()) {
            if (shouldPurge == null) {
                shouldPurge = controller.shouldPurge(key);
            }
            if (shouldPurge.booleanValue()) {
                CounterColumn.mergeAndRemoveOldShards(key, compacted, controller.gcBefore, controller.mergeShardBefore);
            }
        }
        return compacted;
    }

    public static ColumnFamily removeDeletedAndOldShards(DecoratedKey key, boolean shouldPurge, CompactionController controller, ColumnFamily cf) {
        ColumnFamily compacted = ColumnFamilyStore.removeDeleted(cf, shouldPurge ? controller.gcBefore : Integer.MIN_VALUE, controller.cfs.indexManager.updaterFor(key, false));
        if (shouldPurge && compacted != null && compacted.metadata().getDefaultValidator().isCommutative()) {
            CounterColumn.mergeAndRemoveOldShards(key, compacted, controller.gcBefore, controller.mergeShardBefore);
        }
        return compacted;
    }

    public PrecompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        this(rows.get(0).getKey(), PrecompactedRow.removeDeletedAndOldShards(rows.get(0).getKey(), controller, PrecompactedRow.merge(rows, controller)));
    }

    private static ColumnFamily merge(List<SSTableIdentityIterator> rows, CompactionController controller) {
        assert (!rows.isEmpty());
        ColumnFamily cf = null;
        SecondaryIndexManager.Updater indexer = null;
        for (SSTableIdentityIterator row : rows) {
            ColumnFamily thisCF;
            try {
                ISortedColumns.Factory factory = cf == null ? TreeMapBackedSortedColumns.factory() : ArrayBackedSortedColumns.factory();
                thisCF = row.getColumnFamilyWithColumns(factory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed merge of rows on row with key: " + row.getKey(), e);
            }
            if (cf == null) {
                cf = thisCF;
                indexer = controller.cfs.indexManager.updaterFor(row.getKey(), false);
                continue;
            }
            cf.addAllWithSizeDelta(thisCF, HeapAllocator.instance, (Function<IColumn, IColumn>)Functions.identity(), indexer);
        }
        return cf;
    }

    @Override
    public long write(DataOutput out) throws IOException {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        ColumnIndex.Builder builder = new ColumnIndex.Builder(this.compactedCf, this.key.key, this.compactedCf.getColumnCount(), buffer);
        this.columnIndex = builder.build(this.compactedCf);
        TypeSizes typeSizes = TypeSizes.NATIVE;
        long delSize = DeletionTime.serializer.serializedSize(this.compactedCf.deletionInfo().getTopLevelDeletion(), typeSizes);
        long dataSize = (long)buffer.getLength() + delSize + (long)typeSizes.sizeof(0);
        out.writeLong(dataSize);
        DeletionInfo.serializer().serializeForSSTable(this.compactedCf.deletionInfo(), out);
        out.writeInt(builder.writtenAtomCount());
        out.write(buffer.getData(), 0, buffer.getLength());
        return dataSize;
    }

    @Override
    public void update(MessageDigest digest) {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            DeletionInfo.serializer().serializeForSSTable(this.compactedCf.deletionInfo(), (DataOutput)buffer);
            buffer.writeInt(this.compactedCf.getColumnCount());
            digest.update(buffer.getData(), 0, buffer.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.compactedCf.updateDigest(digest);
    }

    @Override
    public boolean isEmpty() {
        return this.compactedCf == null;
    }

    @Override
    public ColumnStats columnStats() {
        return this.compactedCf.getColumnStats();
    }

    public ColumnFamily getFullColumnFamily() {
        return this.compactedCf;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.compactedCf.deletionInfo();
    }

    @Override
    public ColumnIndex index() {
        return this.columnIndex;
    }
}

