/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class LeveledCompactionTask
extends CompactionTask {
    private final int sstableSizeInMB;
    private final CountDownLatch latch = new CountDownLatch(1);

    public LeveledCompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore, int sstableSizeInMB) {
        super(cfs, sstables, gcBefore);
        this.sstableSizeInMB = sstableSizeInMB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(CompactionManager.CompactionExecutorStatsCollector collector) {
        try {
            int n = super.execute(collector);
            return n;
        }
        finally {
            this.latch.countDown();
        }
    }

    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean markSSTablesForCompaction(int min, int max) {
        return super.markSSTablesForCompaction(1, Integer.MAX_VALUE);
    }

    @Override
    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
        return writer.getOnDiskFilePointer() > (long)this.sstableSizeInMB * 1024L * 1024L;
    }

    @Override
    protected boolean isCompactionInteresting(Set<SSTableReader> toCompact) {
        return true;
    }

    @Override
    protected boolean partialCompactionsAcceptable() {
        return false;
    }

    @Override
    protected void cancel() {
        this.latch.countDown();
    }
}

