/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.ParallelCompactionIterable;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected final int gcBefore;
    protected static long totalBytesCompacted = 0L;
    private Set<SSTableReader> toCompact;
    private CompactionManager.CompactionExecutorStatsCollector collector;

    public CompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) {
        super(cfs, sstables);
        this.gcBefore = gcBefore;
        this.toCompact = new HashSet<SSTableReader>(sstables);
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    @Override
    public int execute(CompactionManager.CompactionExecutorStatsCollector collector) {
        this.collector = collector;
        this.run();
        return this.toCompact.size();
    }

    @Override
    public long getExpectedWriteSize() {
        return this.cfs.getExpectedCompactedFileSize(this.toCompact, this.compactionType);
    }

    @Override
    public boolean reduceScopeForLimitedSpace() {
        if (this.partialCompactionsAcceptable() && this.toCompact.size() > 1) {
            logger.warn("insufficient space to compact all requested files " + StringUtils.join(this.toCompact, (String)", "));
            return this.toCompact.remove(this.cfs.getMaxSizeFile(this.toCompact));
        }
        return false;
    }

    @Override
    protected void runWith(File dataDirectory) throws Exception {
        assert (this.sstables != null && dataDirectory != null);
        if (!this.isCompactionInteresting(this.toCompact)) {
            return;
        }
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            this.cfs.snapshotWithoutFlush(System.currentTimeMillis() + "-compact-" + this.cfs.columnFamily);
        }
        for (SSTableReader sstable : this.toCompact) {
            assert (sstable.descriptor.cfname.equals(this.cfs.columnFamily));
        }
        CompactionController controller = new CompactionController(this.cfs, this.toCompact, this.gcBefore, this.isUserDefined);
        logger.info("Compacting {}", this.toCompact);
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        AbstractCompactionStrategy strategy = this.cfs.getCompactionStrategy();
        long estimatedTotalKeys = Math.max((long)DatabaseDescriptor.getIndexInterval().intValue(), SSTableReader.getApproximateKeyCount(this.toCompact));
        long estimatedSSTables = Math.max(1L, SSTable.getTotalBytes(this.toCompact) / strategy.getMaxSSTableSize());
        long keysPerSSTable = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
        if (logger.isDebugEnabled()) {
            logger.debug("Expected bloom filter size : " + keysPerSSTable);
        }
        AbstractCompactionIterable ci = DatabaseDescriptor.isMultithreadedCompaction() ? new ParallelCompactionIterable(this.compactionType, strategy.getScanners(this.toCompact), controller) : new CompactionIterable(this.compactionType, strategy.getScanners(this.toCompact), controller);
        Iterator iter = ci.iterator();
        UnmodifiableIterator nni = Iterators.filter((Iterator)iter, (Predicate)Predicates.notNull());
        HashMap<DecoratedKey, RowIndexEntry> cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
        HashMap<SSTableReader, HashMap<DecoratedKey, RowIndexEntry>> cachedKeyMap = new HashMap<SSTableReader, HashMap<DecoratedKey, RowIndexEntry>>();
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
        ArrayList<SSTableWriter> writers = new ArrayList<SSTableWriter>();
        if (this.collector != null) {
            this.collector.beginCompaction(ci);
        }
        try {
            if (!nni.hasNext()) {
                this.cfs.markCompacted(this.toCompact, this.compactionType);
                return;
            }
            SSTableWriter writer = this.cfs.createCompactionWriter(keysPerSSTable, this.cfs.directories.getLocationForDisk(dataDirectory), this.toCompact);
            writers.add(writer);
            while (nni.hasNext()) {
                if (ci.isStopRequested()) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                if (row.isEmpty()) continue;
                RowIndexEntry indexEntry = writer.append(row);
                ++totalkeysWritten;
                if (DatabaseDescriptor.getPreheatKeyCache()) {
                    for (SSTableReader sSTableReader : this.toCompact) {
                        if (sSTableReader.getCachedPosition(row.key, false) == null) continue;
                        cachedKeys.put(row.key, indexEntry);
                        break;
                    }
                }
                if (nni.hasNext() && !this.newSSTableSegmentThresholdReached(writer)) continue;
                SSTableReader toIndex = writer.closeAndOpenReader(CompactionTask.getMaxDataAge(this.toCompact));
                cachedKeyMap.put(toIndex, cachedKeys);
                sstables.add(toIndex);
                if (!nni.hasNext()) continue;
                writer = this.cfs.createCompactionWriter(keysPerSSTable, this.cfs.directories.getLocationForDisk(dataDirectory), this.toCompact);
                writers.add(writer);
                cachedKeys = new HashMap();
            }
        }
        catch (Throwable t) {
            for (SSTableWriter writer : writers) {
                writer.abort();
            }
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            try {
                iter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.collector != null) {
                this.collector.finishCompaction(ci);
            }
        }
        this.cfs.replaceCompactedSSTables(this.toCompact, sstables, this.compactionType);
        for (Map.Entry ssTableReaderMapEntry : cachedKeyMap.entrySet()) {
            SSTableReader key = (SSTableReader)ssTableReaderMapEntry.getKey();
            for (Map.Entry entry : ((Map)ssTableReaderMapEntry.getValue()).entrySet()) {
                key.cacheKey((DecoratedKey)entry.getKey(), (RowIndexEntry)entry.getValue());
            }
        }
        long dTime = System.currentTimeMillis() - startTime;
        long startsize = SSTable.getTotalBytes(this.toCompact);
        long l = SSTable.getTotalBytes(sstables);
        double ratio = (double)l / (double)startsize;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (SSTableReader reader : sstables) {
            builder.append(reader.getFilename()).append(",");
        }
        builder.append("]");
        double mbps = dTime > 0L ? (double)l / 1048576.0 / ((double)dTime / 1000.0) : 0.0;
        logger.info(String.format("Compacted to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys at %fMB/s.  Time: %,dms.", builder.toString(), startsize, l, (int)(ratio * 100.0), totalkeysWritten, mbps, dTime));
        logger.debug(String.format("CF Total Bytes Compacted: %,d", CompactionTask.addToTotalBytesCompacted(l)));
    }

    protected boolean partialCompactionsAcceptable() {
        return !this.isUserDefined;
    }

    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
        return false;
    }

    protected boolean isCompactionInteresting(Set<SSTableReader> toCompact) {
        if (this.isUserDefined || toCompact.size() >= 2) {
            return true;
        }
        logger.info(String.format("Nothing to compact in %s.  Use forceUserDefinedCompaction if you wish to force compaction of single sstables (e.g. for tombstone collection)", this.cfs.getColumnFamilyName()));
        return false;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }
}

