/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;

public abstract class AbstractCompactionStrategy {
    protected static final float DEFAULT_TOMBSTONE_THRESHOLD = 0.2f;
    protected static final String TOMBSTONE_THRESHOLD_KEY = "tombstone_threshold";
    protected final ColumnFamilyStore cfs;
    protected final Map<String, String> options;
    protected float tombstoneThreshold;

    protected AbstractCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        assert (cfs != null);
        this.cfs = cfs;
        this.options = options;
        String optionValue = options.get(TOMBSTONE_THRESHOLD_KEY);
        this.tombstoneThreshold = optionValue == null ? 0.2f : Float.parseFloat(optionValue);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void shutdown() {
    }

    public abstract AbstractCompactionTask getNextBackgroundTask(int var1);

    public abstract AbstractCompactionTask getMaximalTask(int var1);

    public abstract AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> var1, int var2);

    public abstract int getEstimatedRemainingTasks();

    public abstract long getMaxSSTableSize();

    public abstract boolean isKeyExistenceExpensive(Set<? extends SSTable> var1);

    public static List<SSTableReader> filterSuspectSSTables(Collection<SSTableReader> originalCandidates) {
        ArrayList<SSTableReader> filteredCandidates = new ArrayList<SSTableReader>();
        for (SSTableReader candidate : originalCandidates) {
            if (candidate.isMarkedSuspect()) continue;
            filteredCandidates.add(candidate);
        }
        return filteredCandidates;
    }

    public List<ICompactionScanner> getScanners(Collection<SSTableReader> sstables, Range<Token> range) {
        ArrayList<ICompactionScanner> scanners = new ArrayList<ICompactionScanner>();
        for (SSTableReader sstable : sstables) {
            scanners.add(sstable.getDirectScanner(range));
        }
        return scanners;
    }

    public List<ICompactionScanner> getScanners(Collection<SSTableReader> toCompact) {
        return this.getScanners(toCompact, null);
    }

    protected boolean worthDroppingTombstones(SSTableReader sstable, int gcBefore) {
        double droppableRatio = sstable.getEstimatedDroppableTombstoneRatio(gcBefore);
        if (droppableRatio <= (double)this.tombstoneThreshold) {
            return false;
        }
        Set<SSTableReader> overlaps = this.cfs.getOverlappingSSTables(Collections.singleton(sstable));
        if (overlaps.isEmpty()) {
            return true;
        }
        long keys = sstable.estimatedKeys();
        HashSet<Range<Token>> ranges = new HashSet<Range<Token>>();
        for (SSTableReader overlap : overlaps) {
            ranges.add(new Range<Token>(overlap.first.token, overlap.last.token, overlap.partitioner));
        }
        long remainingKeys = keys - sstable.estimatedKeysForRanges(ranges);
        double remainingKeysRatio = (double)remainingKeys / (double)keys;
        long columns = sstable.getEstimatedColumnCount().percentile(remainingKeysRatio) * remainingKeys;
        double remainingColumnsRatio = (double)columns / (double)(sstable.getEstimatedColumnCount().count() * sstable.getEstimatedColumnCount().mean());
        return remainingColumnsRatio * droppableRatio > (double)this.tombstoneThreshold;
    }
}

