/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommitLogDescriptor {
    private static final String SEPARATOR = "-";
    private static final String FILENAME_PREFIX = "CommitLog-";
    private static final String FILENAME_EXTENSION = ".log";
    private static final Pattern COMMIT_LOG_FILE_PATTERN = Pattern.compile("CommitLog-((\\d+)(-\\d+)?).log");
    public static final int LEGACY_VERSION = 1;
    public static final int VERSION_12 = 2;
    public static final int current_version = 2;
    private final int version;
    public final long id;

    public CommitLogDescriptor(int version, long id) {
        this.version = version;
        this.id = id;
    }

    public CommitLogDescriptor(long id) {
        this(2, id);
    }

    public static CommitLogDescriptor fromFileName(String name) {
        Matcher matcher = COMMIT_LOG_FILE_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new RuntimeException("Cannot parse the version of the file: " + name);
        }
        if (matcher.group(3) != null) {
            long id = Long.parseLong(matcher.group(3).split(SEPARATOR)[1]);
            return new CommitLogDescriptor(Integer.parseInt(matcher.group(2)), id);
        }
        long id = Long.parseLong(matcher.group(1));
        return new CommitLogDescriptor(1, id);
    }

    public int getMessagingVersion() {
        switch (this.version) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalStateException("Unknown commitlog version " + this.version);
    }

    public String fileName() {
        return FILENAME_PREFIX + this.version + SEPARATOR + this.id + FILENAME_EXTENSION;
    }

    public static boolean isValid(String filename) {
        return COMMIT_LOG_FILE_PATTERN.matcher(filename).matches();
    }
}

