/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Filter;
import org.apache.cassandra.utils.FilterFactory;

public class RowIndexEntry {
    public static final Serializer serializer = new Serializer();
    public final long position;

    public RowIndexEntry(long position) {
        this.position = position;
    }

    public int serializedSize() {
        return TypeSizes.NATIVE.sizeof(this.position);
    }

    public static RowIndexEntry create(long position, DeletionInfo deletionInfo, ColumnIndex index) {
        if (index != null && index.columnsIndex != null && index.columnsIndex.size() > 1) {
            return new IndexedEntry(position, deletionInfo, index.columnsIndex, index.bloomFilter);
        }
        return new RowIndexEntry(position);
    }

    public boolean isIndexed() {
        return !this.columnsIndex().isEmpty();
    }

    public DeletionInfo deletionInfo() {
        throw new UnsupportedOperationException();
    }

    public List<IndexHelper.IndexInfo> columnsIndex() {
        return Collections.emptyList();
    }

    public Filter bloomFilter() {
        throw new UnsupportedOperationException();
    }

    private static class IndexedEntry
    extends RowIndexEntry {
        private final DeletionInfo deletionInfo;
        private final List<IndexHelper.IndexInfo> columnsIndex;
        private final Filter bloomFilter;

        private IndexedEntry(long position, DeletionInfo deletionInfo, List<IndexHelper.IndexInfo> columnsIndex, Filter bloomFilter) {
            super(position);
            assert (deletionInfo != null);
            assert (columnsIndex != null && columnsIndex.size() > 1);
            this.deletionInfo = deletionInfo;
            this.columnsIndex = columnsIndex;
            this.bloomFilter = bloomFilter;
        }

        @Override
        public DeletionInfo deletionInfo() {
            return this.deletionInfo;
        }

        @Override
        public List<IndexHelper.IndexInfo> columnsIndex() {
            return this.columnsIndex;
        }

        @Override
        public Filter bloomFilter() {
            return this.bloomFilter;
        }

        @Override
        public int serializedSize() {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            long size = DeletionTime.serializer.serializedSize(this.deletionInfo.getTopLevelDeletion(), typeSizes);
            size += (long)typeSizes.sizeof(this.columnsIndex.size());
            for (IndexHelper.IndexInfo info : this.columnsIndex) {
                size += (long)info.serializedSize(typeSizes);
            }
            assert ((size += FilterFactory.serializedSize(this.bloomFilter)) <= Integer.MAX_VALUE);
            return (int)size;
        }
    }

    public static class Serializer {
        public void serialize(RowIndexEntry rie, DataOutput dos) throws IOException {
            dos.writeLong(rie.position);
            if (rie.isIndexed()) {
                dos.writeInt(((IndexedEntry)rie).serializedSize());
                DeletionInfo.serializer().serializeForSSTable(rie.deletionInfo(), dos);
                dos.writeInt(rie.columnsIndex().size());
                for (IndexHelper.IndexInfo info : rie.columnsIndex()) {
                    info.serialize(dos);
                }
                FilterFactory.serialize(rie.bloomFilter(), dos);
            } else {
                dos.writeInt(0);
            }
        }

        public RowIndexEntry deserializePositionOnly(DataInput dis, Descriptor.Version version) throws IOException {
            int size;
            long position = dis.readLong();
            if (version.hasPromotedIndexes && (size = dis.readInt()) > 0) {
                FileUtils.skipBytesFully(dis, size);
            }
            return new RowIndexEntry(position);
        }

        public RowIndexEntry deserialize(DataInput dis, Descriptor.Version version) throws IOException {
            long position = dis.readLong();
            if (version.hasPromotedIndexes) {
                int size = dis.readInt();
                if (size > 0) {
                    DeletionInfo delInfo = DeletionInfo.serializer().deserializeFromSSTable(dis, version);
                    int entries = dis.readInt();
                    ArrayList<IndexHelper.IndexInfo> columnsIndex = new ArrayList<IndexHelper.IndexInfo>(entries);
                    for (int i = 0; i < entries; ++i) {
                        columnsIndex.add(IndexHelper.IndexInfo.deserialize(dis));
                    }
                    Filter bf = FilterFactory.deserialize(dis, version.filterType);
                    return new IndexedEntry(position, delInfo, columnsIndex, bf);
                }
                return new RowIndexEntry(position);
            }
            return new RowIndexEntry(position);
        }

        public void skip(DataInput dis, Descriptor.Version version) throws IOException {
            dis.readLong();
            if (version.hasPromotedIndexes) {
                this.skipPromotedIndex(dis);
            }
        }

        public void skipPromotedIndex(DataInput dis) throws IOException {
            int size = dis.readInt();
            if (size <= 0) {
                return;
            }
            FileUtils.skipBytesFully(dis, size);
        }
    }
}

