/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class ModificationStatement
extends CFStatement
implements CQLStatement {
    public static final ConsistencyLevel defaultConsistency = ConsistencyLevel.ONE;
    private final ConsistencyLevel cLevel;
    private Long timestamp;
    private final int timeToLive;

    public ModificationStatement(CFName name, Attributes attrs) {
        this(name, attrs.cLevel, attrs.timestamp, attrs.timeToLive);
    }

    public ModificationStatement(CFName name, ConsistencyLevel cLevel, Long timestamp, int timeToLive) {
        super(name);
        this.cLevel = cLevel;
        this.timestamp = timestamp;
        this.timeToLive = timeToLive;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.UPDATE);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.timeToLive < 0) {
            throw new InvalidRequestException("A TTL must be greater or equal to 0");
        }
        this.getConsistencyLevel().validateForWrite(this.keyspace());
    }

    @Override
    public ResultMessage execute(ClientState state, List<ByteBuffer> variables) throws RequestExecutionException, RequestValidationException {
        StorageProxy.mutate(this.getMutations(state, variables), this.getConsistencyLevel());
        return null;
    }

    public ConsistencyLevel getConsistencyLevel() {
        if (this.cLevel != null) {
            return this.cLevel;
        }
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily());
        return cfm == null ? ConsistencyLevel.ONE : cfm.getWriteConsistencyLevel();
    }

    public boolean isSetConsistencyLevel() {
        return this.cLevel != null;
    }

    public long getTimestamp(ClientState clientState) {
        return this.timestamp == null ? clientState.getTimestamp() : this.timestamp.longValue();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isSetTimestamp() {
        return this.timestamp != null;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public Map<ByteBuffer, ColumnGroupMap> readRows(List<ByteBuffer> keys, ColumnNameBuilder builder, CompositeType composite) throws RequestExecutionException, RequestValidationException {
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        for (ByteBuffer key : keys) {
            commands.add(new SliceFromReadCommand(this.keyspace(), key, new QueryPath(this.columnFamily()), builder.copy().build(), builder.copy().buildAsEndOfRange(), false, Integer.MAX_VALUE));
        }
        try {
            List<Row> rows = StorageProxy.read(commands, this.getConsistencyLevel());
            HashMap<ByteBuffer, ColumnGroupMap> map = new HashMap<ByteBuffer, ColumnGroupMap>();
            for (Row row : rows) {
                if (row.cf == null || row.cf.isEmpty()) continue;
                ColumnGroupMap.Builder groupBuilder = new ColumnGroupMap.Builder(composite, true);
                for (IColumn column : row.cf) {
                    groupBuilder.add(column);
                }
                List<ColumnGroupMap> groups = groupBuilder.groups();
                assert (groups.isEmpty() || groups.size() == 1);
                if (groups.isEmpty()) continue;
                map.put(row.key.key, groups.get(0));
            }
            return map;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public abstract List<IMutation> getMutations(ClientState var1, List<ByteBuffer> var2) throws RequestExecutionException, RequestValidationException;

    public abstract ParsedStatement.Prepared prepare(CFDefinition.Name[] var1) throws InvalidRequestException;
}

