/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;

public class DropColumnFamilyStatement
extends SchemaAlteringStatement {
    public DropColumnFamilyStatement(CFName name) {
        super(name);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.DROP);
    }

    @Override
    public void announceMigration() throws ConfigurationException {
        MigrationManager.announceColumnFamilyDrop(this.keyspace(), this.columnFamily());
    }
}

