/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.HashMap;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.ThriftValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final ColumnIdentifier columnName;

    public CreateIndexStatement(CFName name, String indexName, ColumnIdentifier columnName) {
        super(name);
        this.indexName = indexName;
        this.columnName = columnName;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData oldCfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        boolean columnExists = false;
        CFMetaData cfm = oldCfm.clone();
        CFDefinition cfDef = oldCfm.getCfDef();
        for (ColumnDefinition cd : cfm.getColumn_metadata().values()) {
            if (!cd.name.equals(this.columnName.key)) continue;
            if (cd.getIndexType() != null) {
                throw new InvalidRequestException("Index already exists");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Updating column {} definition for index {}", (Object)this.columnName, (Object)this.indexName);
            }
            if (cfDef.isComposite) {
                CompositeType composite = (CompositeType)cfm.comparator;
                HashMap<String, String> opts = new HashMap<String, String>();
                opts.put("prefix_size", String.valueOf(composite.types.size() - 1));
                cd.setIndexType(IndexType.COMPOSITES, opts);
            } else {
                cd.setIndexType(IndexType.KEYS, Collections.<String, String>emptyMap());
            }
            cd.setIndexName(this.indexName);
            columnExists = true;
            break;
        }
        if (!columnExists) {
            CFDefinition.Name name = cfDef.get(this.columnName);
            if (name != null) {
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot create index on PRIMARY KEY part %s", this.columnName));
                    }
                    case VALUE_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot create index on column %s of compact CF", this.columnName));
                    }
                }
            }
            throw new InvalidRequestException("No column definition found for column " + this.columnName);
        }
        cfm.addDefaultIndexNames();
        MigrationManager.announceColumnFamilyUpdate(cfm);
    }
}

