/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.AbstractModification;
import org.apache.cassandra.cql.Attributes;
import org.apache.cassandra.cql.Operation;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.ThriftValidation;

public class UpdateStatement
extends AbstractModification {
    private Map<Term, Operation> columns;
    private List<Term> columnNames;
    private List<Term> columnValues;
    private final List<Term> keys;

    public UpdateStatement(String keyspace, String columnFamily, String keyName, Map<Term, Operation> columns, List<Term> keys, Attributes attrs) {
        super(keyspace, columnFamily, keyName, attrs);
        this.columns = columns;
        this.keys = keys;
    }

    public UpdateStatement(String keyspace, String columnFamily, String keyName, List<Term> columnNames, List<Term> columnValues, List<Term> keys, Attributes attrs) {
        super(keyspace, columnFamily, keyName, attrs);
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.keys = keys;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.cLevel != null ? this.cLevel : defaultConsistency;
    }

    @Override
    public boolean isSetConsistencyLevel() {
        return this.cLevel != null;
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        return this.prepareRowMutations(keyspace, clientState, null, variables);
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ClientState clientState, Long timestamp, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        ArrayList<String> cfamsSeen = new ArrayList<String>();
        boolean hasCommutativeOperation = false;
        for (Map.Entry<Term, Operation> column : this.getColumns().entrySet()) {
            if (!column.getValue().isUnary()) {
                hasCommutativeOperation = true;
            }
            if (!hasCommutativeOperation || !column.getValue().isUnary()) continue;
            throw new InvalidRequestException("Mix of commutative and non-commutative operations is not allowed.");
        }
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, this.columnFamily, hasCommutativeOperation);
        if (hasCommutativeOperation) {
            this.cLevel.validateCounterForWrite(metadata);
        }
        QueryProcessor.validateKeyAlias(metadata, this.keyName);
        if (!cfamsSeen.contains(this.columnFamily)) {
            clientState.hasColumnFamilyAccess(this.columnFamily, Permission.UPDATE);
            cfamsSeen.add(this.columnFamily);
        }
        LinkedList<IMutation> rowMutations = new LinkedList<IMutation>();
        for (Term key : this.keys) {
            rowMutations.add(this.mutationForKey(keyspace, key.getByteBuffer(this.getKeyType(keyspace), variables), metadata, timestamp, clientState, variables));
        }
        return rowMutations;
    }

    private IMutation mutationForKey(String keyspace, ByteBuffer key, CFMetaData metadata, Long timestamp, ClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException {
        QueryProcessor.validateKey(key);
        AbstractType<?> comparator = this.getComparator(keyspace);
        boolean hasCounterColumn = false;
        RowMutation rm = new RowMutation(keyspace, key);
        for (Map.Entry<Term, Operation> column : this.getColumns().entrySet()) {
            long value;
            ByteBuffer colName = column.getKey().getByteBuffer(comparator, variables);
            Operation op = column.getValue();
            if (op.isUnary()) {
                if (hasCounterColumn) {
                    throw new InvalidRequestException("Mix of commutative and non-commutative operations is not allowed.");
                }
                ByteBuffer colValue = op.a.getByteBuffer(this.getValueValidator(keyspace, colName), variables);
                QueryProcessor.validateColumn(metadata, colName, colValue);
                rm.add(new QueryPath(this.columnFamily, null, colName), colValue, timestamp == null ? this.getTimestamp(clientState) : timestamp.longValue(), this.getTimeToLive());
                continue;
            }
            hasCounterColumn = true;
            if (!column.getKey().getText().equals(op.a.getText())) {
                throw new InvalidRequestException("Only expressions like X = X + <long> are supported.");
            }
            try {
                value = Long.parseLong(op.b.getText());
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("'%s' is an invalid value, should be a long.", op.b.getText()));
            }
            rm.addCounter(new QueryPath(this.columnFamily, null, colName), value);
        }
        return hasCounterColumn ? new CounterMutation(rm, this.getConsistencyLevel()) : rm;
    }

    @Override
    public String getColumnFamily() {
        return this.columnFamily;
    }

    public List<Term> getKeys() {
        return this.keys;
    }

    public Map<Term, Operation> getColumns() throws InvalidRequestException {
        if (this.columns != null) {
            return this.columns;
        }
        if (this.columnNames.size() != this.columnValues.size()) {
            throw new InvalidRequestException("unmatched column names/values");
        }
        if (this.columnNames.size() < 1) {
            throw new InvalidRequestException("no columns specified for INSERT");
        }
        this.columns = new HashMap<Term, Operation>();
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.columns.put(this.columnNames.get(i), new Operation(this.columnValues.get(i)));
        }
        return this.columns;
    }

    public String toString() {
        return String.format("UpdateStatement(keyspace=%s, columnFamily=%s, keys=%s, columns=%s, consistency=%s, timestamp=%s, timeToLive=%s)", new Object[]{this.keyspace, this.columnFamily, this.keys, this.columns, this.getConsistencyLevel(), this.timestamp, this.timeToLive});
    }

    public AbstractType<?> getKeyType(String keyspace) {
        return Schema.instance.getCFMetaData(keyspace, this.columnFamily).getKeyValidator();
    }

    public AbstractType<?> getComparator(String keyspace) {
        return Schema.instance.getComparator(keyspace, this.columnFamily);
    }

    public AbstractType<?> getValueValidator(String keyspace, ByteBuffer column) {
        return Schema.instance.getValueValidator(keyspace, this.columnFamily, column);
    }

    public List<Term> getColumnNames() {
        return this.columnNames;
    }

    public List<Term> getColumnValues() {
        return this.columnValues;
    }
}

