/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.cassandra.config.Avro;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.migration.avro.KsDef;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefsTable {
    private static final Logger logger = LoggerFactory.getLogger(DefsTable.class);
    private static final DecoderFactory DIRECT_DECODERS = new DecoderFactory().configureDirectDecoder(true);
    public static final ByteBuffer DEFINITION_SCHEMA_COLUMN_NAME = ByteBufferUtil.bytes("Avro/Schema");
    public static final String OLD_MIGRATIONS_CF = "Migrations";
    public static final String OLD_SCHEMA_CF = "Schema";

    public static synchronized void dumpToStorage(Collection<KSMetaData> keyspaces) throws IOException {
        long timestamp = System.currentTimeMillis();
        for (KSMetaData ksMetaData : keyspaces) {
            ksMetaData.toSchema(timestamp).apply();
        }
    }

    public static Collection<KSMetaData> loadFromTable() throws IOException {
        List<Row> serializedSchema = SystemTable.serializedSchema("schema_keyspaces");
        ArrayList<KSMetaData> keyspaces = new ArrayList<KSMetaData>(serializedSchema.size());
        for (Row row : serializedSchema) {
            if (DefsTable.invalidSchemaRow(row)) continue;
            keyspaces.add(KSMetaData.fromSchema(row, DefsTable.serializedColumnFamilies(row.key)));
        }
        return keyspaces;
    }

    public static void fixSchemaNanoTimestamps() throws IOException {
        DefsTable.fixSchemaNanoTimestamp("schema_keyspaces");
        DefsTable.fixSchemaNanoTimestamp("schema_columnfamilies");
        DefsTable.fixSchemaNanoTimestamp("schema_columns");
    }

    private static void fixSchemaNanoTimestamp(String columnFamily) throws IOException {
        ColumnFamilyStore cfs = Table.open("system").getColumnFamilyStore(columnFamily);
        boolean needsCleanup = false;
        Date now = new Date();
        List<Row> rows = SystemTable.serializedSchema(columnFamily);
        block6: for (Row row : rows) {
            if (DefsTable.invalidSchemaRow(row)) continue;
            for (IColumn column : row.cf.columns) {
                Date columnDate = new Date(column.timestamp());
                if (columnDate.after(now)) {
                    Date micros = new Date(column.timestamp() / 1000L);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(micros);
                    if ((!micros.before(now) || calendar.get(1) != 1970) && !micros.after(now)) continue;
                    needsCleanup = true;
                    break block6;
                }
                needsCleanup = true;
                break block6;
            }
        }
        if (!needsCleanup) {
            return;
        }
        logger.info("Fixing timestamps of schema ColumnFamily " + columnFamily + "...");
        try {
            cfs.truncate().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        long microTimestamp = now.getTime() * 1000L;
        for (Row row : rows) {
            if (DefsTable.invalidSchemaRow(row)) continue;
            RowMutation mutation = new RowMutation("system", row.key.key);
            for (IColumn column : row.cf.columns) {
                if (!column.isLive()) continue;
                mutation.add(new QueryPath(columnFamily, null, column.name()), column.value(), microTimestamp);
            }
            mutation.apply();
        }
        try {
            cfs.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Could not flush after fixing schema timestamps", e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean invalidSchemaRow(Row row) {
        return row.cf == null || row.cf.isMarkedForDelete() && row.cf.isEmpty();
    }

    public static ByteBuffer searchComposite(String name, boolean start) {
        assert (name != null);
        ByteBuffer nameBytes = UTF8Type.instance.decompose(name);
        int length = nameBytes.remaining();
        byte[] bytes = new byte[2 + length + 1];
        bytes[0] = (byte)(length >> 8 & 0xFF);
        bytes[1] = (byte)(length & 0xFF);
        ByteBufferUtil.arrayCopy(nameBytes, 0, bytes, 2, length);
        bytes[bytes.length - 1] = (byte)(!start ? 1 : 0);
        return ByteBuffer.wrap(bytes);
    }

    private static Row serializedColumnFamilies(DecoratedKey ksNameKey) {
        ColumnFamilyStore cfsStore = SystemTable.schemaCFS("schema_columnfamilies");
        return new Row(ksNameKey, cfsStore.getColumnFamily(QueryFilter.getIdentityFilter(ksNameKey, new QueryPath("schema_columnfamilies"))));
    }

    public static synchronized Collection<KSMetaData> loadFromStorage(UUID version) throws IOException {
        DecoratedKey vkey = StorageService.getPartitioner().decorateKey(DefsTable.toUTF8Bytes(version));
        Table defs = Table.open("system");
        ColumnFamilyStore cfStore = defs.getColumnFamilyStore(OLD_SCHEMA_CF);
        ColumnFamily cf = cfStore.getColumnFamily(QueryFilter.getIdentityFilter(vkey, new QueryPath(OLD_SCHEMA_CF)));
        IColumn avroschema = cf.getColumn(DEFINITION_SCHEMA_COLUMN_NAME);
        List<KSMetaData> keyspaces = Collections.emptyList();
        if (avroschema != null) {
            ByteBuffer value = avroschema.value();
            Schema schema = Schema.parse((String)ByteBufferUtil.string(value));
            Collection<IColumn> columns = cf.getSortedColumns();
            keyspaces = new ArrayList<KSMetaData>(columns.size());
            for (IColumn column : columns) {
                if (column.name().equals(DEFINITION_SCHEMA_COLUMN_NAME)) continue;
                KsDef ks = DefsTable.deserializeAvro(schema, column.value(), new KsDef());
                keyspaces.add(Avro.ksFromAvro(ks));
            }
            DefsTable.dumpToStorage(keyspaces);
            logger.info("Truncating deprecated system column families (migrations, schema)...");
            DefsTable.dropColumnFamily("system", OLD_MIGRATIONS_CF);
            DefsTable.dropColumnFamily("system", OLD_SCHEMA_CF);
        }
        return keyspaces;
    }

    public static void mergeRemoteSchema(byte[] data, int version) throws ConfigurationException, IOException {
        if (version < 5) {
            logger.error("Can't accept schema migrations from Cassandra versions previous to 1.1.6, please update first.");
            return;
        }
        DefsTable.mergeSchema(MigrationManager.deserializeMigrationMessage(data, version));
    }

    public static synchronized void mergeSchema(Collection<RowMutation> mutations) throws ConfigurationException, IOException {
        Map<DecoratedKey, ColumnFamily> oldKeyspaces = SystemTable.getSchema("schema_keyspaces");
        Map<DecoratedKey, ColumnFamily> oldColumnFamilies = SystemTable.getSchema("schema_columnfamilies");
        for (RowMutation mutation : mutations) {
            mutation.apply();
        }
        if (!StorageService.instance.isClientMode()) {
            DefsTable.flushSchemaCFs();
        }
        org.apache.cassandra.config.Schema.instance.updateVersionAndAnnounce();
        Map<DecoratedKey, ColumnFamily> newKeyspaces = SystemTable.getSchema("schema_keyspaces");
        Map<DecoratedKey, ColumnFamily> newColumnFamilies = SystemTable.getSchema("schema_columnfamilies");
        Set<String> keyspacesToDrop = DefsTable.mergeKeyspaces(oldKeyspaces, newKeyspaces);
        DefsTable.mergeColumnFamilies(oldColumnFamilies, newColumnFamilies);
        for (String keyspaceToDrop : keyspacesToDrop) {
            DefsTable.dropKeyspace(keyspaceToDrop);
        }
    }

    private static Set<String> mergeKeyspaces(Map<DecoratedKey, ColumnFamily> old, Map<DecoratedKey, ColumnFamily> updated) throws ConfigurationException, IOException {
        MapDifference diff = Maps.difference(old, updated);
        for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
            ColumnFamily ksAttrs = (ColumnFamily)entry.getValue();
            if (ksAttrs.isEmpty()) continue;
            DefsTable.addKeyspace(KSMetaData.fromSchema(new Row((DecoratedKey)entry.getKey(), (ColumnFamily)entry.getValue()), Collections.<CFMetaData>emptyList()));
        }
        Map modifiedEntries = diff.entriesDiffering();
        ArrayList leftToProcess = new ArrayList(modifiedEntries.size());
        for (Map.Entry entry : modifiedEntries.entrySet()) {
            ColumnFamily prevValue = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).leftValue();
            ColumnFamily newValue = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).rightValue();
            if (prevValue.isEmpty()) {
                DefsTable.addKeyspace(KSMetaData.fromSchema(new Row((DecoratedKey)entry.getKey(), newValue), Collections.<CFMetaData>emptyList()));
                continue;
            }
            leftToProcess.add(entry.getKey());
        }
        if (leftToProcess.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> keyspacesToDrop = new HashSet<String>();
        for (DecoratedKey key : leftToProcess) {
            MapDifference.ValueDifference valueDiff = (MapDifference.ValueDifference)modifiedEntries.get(key);
            ColumnFamily newState = (ColumnFamily)valueDiff.rightValue();
            if (newState.isEmpty()) {
                keyspacesToDrop.add(AsciiType.instance.getString(key.key));
                continue;
            }
            DefsTable.updateKeyspace(KSMetaData.fromSchema(new Row(key, newState), Collections.<CFMetaData>emptyList()));
        }
        return keyspacesToDrop;
    }

    private static void mergeColumnFamilies(Map<DecoratedKey, ColumnFamily> old, Map<DecoratedKey, ColumnFamily> updated) throws ConfigurationException, IOException {
        MapDifference diff = Maps.difference(old, updated);
        for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
            ColumnFamily cfAttrs = (ColumnFamily)entry.getValue();
            if (cfAttrs.isEmpty()) continue;
            Map<String, CFMetaData> cfDefs = KSMetaData.deserializeColumnFamilies(new Row((DecoratedKey)entry.getKey(), cfAttrs));
            for (CFMetaData cfDef : cfDefs.values()) {
                DefsTable.addColumnFamily(cfDef);
            }
        }
        Map modifiedEntries = diff.entriesDiffering();
        for (DecoratedKey keyspace : modifiedEntries.keySet()) {
            MapDifference.ValueDifference valueDiff = (MapDifference.ValueDifference)modifiedEntries.get(keyspace);
            ColumnFamily prevValue = (ColumnFamily)valueDiff.leftValue();
            ColumnFamily newValue = (ColumnFamily)valueDiff.rightValue();
            Row newRow = new Row(keyspace, newValue);
            if (prevValue.isEmpty()) {
                for (CFMetaData cfm : KSMetaData.deserializeColumnFamilies(newRow).values()) {
                    DefsTable.addColumnFamily(cfm);
                }
                continue;
            }
            if (newValue.isEmpty()) {
                for (CFMetaData cfm : KSMetaData.deserializeColumnFamilies(new Row(keyspace, prevValue)).values()) {
                    DefsTable.dropColumnFamily(cfm.ksName, cfm.cfName);
                }
                continue;
            }
            String ksName = AsciiType.instance.getString(keyspace.key);
            HashMap<String, CFMetaData> oldCfDefs = new HashMap<String, CFMetaData>();
            for (CFMetaData cfm : org.apache.cassandra.config.Schema.instance.getKSMetaData(ksName).cfMetaData().values()) {
                oldCfDefs.put(cfm.cfName, cfm);
            }
            Map<String, CFMetaData> newCfDefs = KSMetaData.deserializeColumnFamilies(newRow);
            MapDifference cfDefDiff = Maps.difference(oldCfDefs, newCfDefs);
            for (CFMetaData cfDef : cfDefDiff.entriesOnlyOnRight().values()) {
                DefsTable.addColumnFamily(cfDef);
            }
            for (CFMetaData cfDef : cfDefDiff.entriesOnlyOnLeft().values()) {
                DefsTable.dropColumnFamily(cfDef.ksName, cfDef.cfName);
            }
            for (CFMetaData cfDef : cfDefDiff.entriesDiffering().values()) {
                DefsTable.updateColumnFamily((CFMetaData)cfDef.rightValue());
            }
        }
    }

    private static void addKeyspace(KSMetaData ksm) {
        assert (org.apache.cassandra.config.Schema.instance.getKSMetaData(ksm.name) == null);
        org.apache.cassandra.config.Schema.instance.load(ksm);
        if (!StorageService.instance.isClientMode()) {
            Table.open(ksm.name);
        }
    }

    private static void addColumnFamily(CFMetaData cfm) throws IOException {
        assert (org.apache.cassandra.config.Schema.instance.getCFMetaData(cfm.ksName, cfm.cfName) == null);
        KSMetaData ksm = org.apache.cassandra.config.Schema.instance.getTableDefinition(cfm.ksName);
        ksm = KSMetaData.cloneWith(ksm, Iterables.concat(ksm.cfMetaData().values(), Collections.singleton(cfm)));
        org.apache.cassandra.config.Schema.instance.load(cfm);
        Table.open(cfm.ksName);
        org.apache.cassandra.config.Schema.instance.setTableDefinition(ksm);
        if (!StorageService.instance.isClientMode()) {
            Table.open(ksm.name).initCf(cfm.cfId, cfm.cfName, true);
        }
    }

    private static void updateKeyspace(KSMetaData newState) throws IOException {
        KSMetaData oldKsm = org.apache.cassandra.config.Schema.instance.getKSMetaData(newState.name);
        assert (oldKsm != null);
        KSMetaData newKsm = KSMetaData.cloneWith(oldKsm.reloadAttributes(), oldKsm.cfMetaData().values());
        org.apache.cassandra.config.Schema.instance.setTableDefinition(newKsm);
        try {
            if (!StorageService.instance.isClientMode()) {
                Table.open(newState.name).createReplicationStrategy(newKsm);
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void updateColumnFamily(CFMetaData newState) throws IOException {
        CFMetaData cfm = org.apache.cassandra.config.Schema.instance.getCFMetaData(newState.ksName, newState.cfName);
        assert (cfm != null);
        cfm.reload();
        if (!StorageService.instance.isClientMode()) {
            Table table = Table.open(cfm.ksName);
            table.getColumnFamilyStore(cfm.cfName).reload();
        }
    }

    private static void dropKeyspace(String ksName) throws IOException {
        KSMetaData ksm = org.apache.cassandra.config.Schema.instance.getTableDefinition(ksName);
        String snapshotName = Table.getTimestampedSnapshotName(ksName);
        CompactionManager.instance.stopCompactionFor(ksm.cfMetaData().values());
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            ColumnFamilyStore cfs = Table.open(ksm.name).getColumnFamilyStore(cfm.cfName);
            org.apache.cassandra.config.Schema.instance.purge(cfm);
            if (StorageService.instance.isClientMode()) continue;
            if (DatabaseDescriptor.isAutoSnapshot()) {
                cfs.snapshot(snapshotName);
            }
            Table.open(ksm.name).dropCf(cfm.cfId);
        }
        Table.clear(ksm.name);
        org.apache.cassandra.config.Schema.instance.clearTableDefinition(ksm);
    }

    private static void dropColumnFamily(String ksName, String cfName) throws IOException {
        KSMetaData ksm = org.apache.cassandra.config.Schema.instance.getTableDefinition(ksName);
        assert (ksm != null);
        ColumnFamilyStore cfs = Table.open(ksName).getColumnFamilyStore(cfName);
        assert (cfs != null);
        CFMetaData cfm = ksm.cfMetaData().get(cfName);
        org.apache.cassandra.config.Schema.instance.purge(cfm);
        org.apache.cassandra.config.Schema.instance.setTableDefinition(DefsTable.makeNewKeyspaceDefinition(ksm, cfm));
        CompactionManager.instance.stopCompactionFor(Arrays.asList(cfm));
        if (!StorageService.instance.isClientMode()) {
            if (DatabaseDescriptor.isAutoSnapshot()) {
                cfs.snapshot(Table.getTimestampedSnapshotName(cfs.columnFamily));
            }
            Table.open(ksm.name).dropCf(cfm.cfId);
        }
    }

    private static KSMetaData makeNewKeyspaceDefinition(KSMetaData ksm, CFMetaData toExclude) {
        ArrayList<CFMetaData> newCfs = new ArrayList<CFMetaData>(ksm.cfMetaData().values());
        newCfs.remove(toExclude);
        assert (newCfs.size() == ksm.cfMetaData().size() - 1);
        return KSMetaData.cloneWith(ksm, newCfs);
    }

    private static void flushSchemaCFs() {
        DefsTable.flushSchemaCF("schema_keyspaces");
        DefsTable.flushSchemaCF("schema_columnfamilies");
        DefsTable.flushSchemaCF("schema_columns");
    }

    private static void flushSchemaCF(String cfName) {
        Future<?> flush = SystemTable.schemaCFS(cfName).forceFlush();
        if (flush != null) {
            FBUtilities.waitOnFuture(flush);
        }
    }

    private static ByteBuffer toUTF8Bytes(UUID version) {
        return ByteBufferUtil.bytes(version.toString());
    }

    public static <T extends SpecificRecord> T deserializeAvro(Schema writer, ByteBuffer bytes, T ob) throws IOException {
        BinaryDecoder dec = DIRECT_DECODERS.createBinaryDecoder(ByteBufferUtil.getArray(bytes), null);
        SpecificDatumReader reader = new SpecificDatumReader(writer);
        reader.setExpected(ob.getSchema());
        return (T)((SpecificRecord)reader.read(ob, (Decoder)dec));
    }
}

