/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterMutationVerbHandler
implements IVerbHandler {
    private static Logger logger = LoggerFactory.getLogger(CounterMutationVerbHandler.class);

    @Override
    public void doVerb(final Message message, final String id) {
        byte[] bytes = message.getMessageBody();
        FastByteArrayInputStream buffer = new FastByteArrayInputStream(bytes);
        try {
            DataInputStream is = new DataInputStream(buffer);
            final CounterMutation cm = CounterMutation.serializer().deserialize(is, message.getVersion());
            if (logger.isDebugEnabled()) {
                logger.debug("Applying forwarded " + cm);
            }
            String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
            StorageProxy.applyCounterMutationOnLeader(cm, localDataCenter, new Runnable(){

                @Override
                public void run() {
                    try {
                        WriteResponse response = new WriteResponse(cm.getTable(), cm.key(), true);
                        Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
                        MessagingService.instance().sendReply(responseMessage, id, message.getFrom());
                    }
                    catch (IOException e) {
                        logger.error("Error writing response to counter mutation", (Throwable)e);
                    }
                }
            });
        }
        catch (UnavailableException e) {
        }
        catch (TimeoutException e) {
        }
        catch (IOException e) {
            logger.error("Error in counter mutation", (Throwable)e);
        }
    }
}

