/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.StreamingServiceMBean;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tools.ColumnFamilyStoreMBeanIterator;
import org.apache.cassandra.tools.ThreadPoolProxyMBeanIterator;

public class NodeProbe {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final String ssObjName = "org.apache.cassandra.db:type=StorageService";
    private static final int defaultPort = 7199;
    final String host;
    final int port;
    private String username;
    private String password;
    private JMXConnector jmxc;
    private MBeanServerConnection mbeanServerConn;
    private CompactionManagerMBean compactionProxy;
    private StorageServiceMBean ssProxy;
    private MemoryMXBean memProxy;
    private RuntimeMXBean runtimeProxy;
    private StreamingServiceMBean streamProxy;
    public MessagingServiceMBean msProxy;
    private FailureDetectorMBean fdProxy;
    private CacheServiceMBean cacheService;
    private StorageProxyMBean spProxy;

    public NodeProbe(String host, int port, String username, String password) throws IOException, InterruptedException {
        assert (username != null && !username.isEmpty() && null != password && !password.isEmpty()) : "neither username nor password can be blank";
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.connect();
    }

    public NodeProbe(String host, int port) throws IOException, InterruptedException {
        this.host = host;
        this.port = port;
        this.connect();
    }

    public NodeProbe(String host) throws IOException, InterruptedException {
        this.host = host;
        this.port = 7199;
        this.connect();
    }

    private void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, this.host, this.port));
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (this.username != null) {
            String[] creds = new String[]{this.username, this.password};
            env.put("jmx.remote.credentials", creds);
        }
        this.jmxc = JMXConnectorFactory.connect(jmxUrl, env);
        this.mbeanServerConn = this.jmxc.getMBeanServerConnection();
        try {
            ObjectName name = new ObjectName(ssObjName);
            this.ssProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=MessagingService");
            this.msProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, MessagingServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=StreamingService");
            this.streamProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StreamingServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=CompactionManager");
            this.compactionProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, CompactionManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=FailureDetector");
            this.fdProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, FailureDetectorMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=Caches");
            this.cacheService = JMX.newMBeanProxy(this.mbeanServerConn, name, CacheServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=StorageProxy");
            this.spProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageProxyMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        this.memProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
        this.runtimeProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    public void close() throws IOException {
        this.jmxc.close();
    }

    public void forceTableCleanup(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceTableCleanup(tableName, columnFamilies);
    }

    public void scrub(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.scrub(tableName, columnFamilies);
    }

    public void upgradeSSTables(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.upgradeSSTables(tableName, columnFamilies);
    }

    public void forceTableCompaction(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceTableCompaction(tableName, columnFamilies);
    }

    public void forceTableFlush(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceTableFlush(tableName, columnFamilies);
    }

    public void forceTableRepair(String tableName, boolean isSequential, String ... columnFamilies) throws IOException {
        this.ssProxy.forceTableRepair(tableName, isSequential, columnFamilies);
    }

    public void forceTableRepairPrimaryRange(String tableName, boolean isSequential, String ... columnFamilies) throws IOException {
        this.ssProxy.forceTableRepairPrimaryRange(tableName, isSequential, columnFamilies);
    }

    public void forceTableRepairRange(String beginToken, String endToken, String tableName, boolean isSequential, String ... columnFamilies) throws IOException {
        this.ssProxy.forceTableRepairRange(beginToken, endToken, tableName, isSequential, columnFamilies);
    }

    public void invalidateKeyCache() throws IOException {
        this.cacheService.invalidateKeyCache();
    }

    public void invalidateRowCache() throws IOException {
        this.cacheService.invalidateRowCache();
    }

    public void drain() throws IOException, InterruptedException, ExecutionException {
        this.ssProxy.drain();
    }

    public Map<String, String> getTokenToEndpointMap() {
        return this.ssProxy.getTokenToEndpointMap();
    }

    public List<String> getLiveNodes() {
        return this.ssProxy.getLiveNodes();
    }

    public List<String> getJoiningNodes() {
        return this.ssProxy.getJoiningNodes();
    }

    public List<String> getLeavingNodes() {
        return this.ssProxy.getLeavingNodes();
    }

    public List<String> getMovingNodes() {
        return this.ssProxy.getMovingNodes();
    }

    public List<String> getUnreachableNodes() {
        return this.ssProxy.getUnreachableNodes();
    }

    public Map<String, String> getLoadMap() {
        return this.ssProxy.getLoadMap();
    }

    public Map<String, Float> getOwnership() {
        return this.ssProxy.getOwnership();
    }

    public Map<String, Float> effectiveOwnership(String keyspace) throws ConfigurationException {
        return this.ssProxy.effectiveOwnership(keyspace);
    }

    public CacheServiceMBean getCacheServiceMBean() {
        String cachePath = "org.apache.cassandra.db:type=Caches";
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(cachePath), CacheServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> getColumnFamilyStoreMBeanProxies() {
        try {
            return new ColumnFamilyStoreMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public CompactionManagerMBean getCompactionManagerProxy() {
        return this.compactionProxy;
    }

    public String getToken() {
        return this.ssProxy.getToken();
    }

    public String getLoadString() {
        return this.ssProxy.getLoadString();
    }

    public String getReleaseVersion() {
        return this.ssProxy.getReleaseVersion();
    }

    public int getCurrentGenerationNumber() {
        return this.ssProxy.getCurrentGenerationNumber();
    }

    public long getUptime() {
        return this.runtimeProxy.getUptime();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.memProxy.getHeapMemoryUsage();
    }

    public void takeSnapshot(String snapshotName, String columnFamily, String ... keyspaces) throws IOException {
        if (columnFamily != null) {
            if (keyspaces.length != 1) {
                throw new IOException("When specifying the column family for a snapshot, you must specify one and only one keyspace");
            }
            this.ssProxy.takeColumnFamilySnapshot(keyspaces[0], columnFamily, snapshotName);
        } else {
            this.ssProxy.takeSnapshot(snapshotName, keyspaces);
        }
    }

    public void clearSnapshot(String tag, String ... keyspaces) throws IOException {
        this.ssProxy.clearSnapshot(tag, keyspaces);
    }

    public boolean isJoined() {
        return this.ssProxy.isJoined();
    }

    public void joinRing() throws IOException, ConfigurationException {
        this.ssProxy.joinRing();
    }

    public void decommission() throws InterruptedException {
        this.ssProxy.decommission();
    }

    public void move(String newToken) throws IOException, InterruptedException, ConfigurationException {
        this.ssProxy.move(newToken);
    }

    public void removeToken(String token) {
        this.ssProxy.removeToken(token);
    }

    public String getRemovalStatus() {
        return this.ssProxy.getRemovalStatus();
    }

    public void forceRemoveCompletion() {
        this.ssProxy.forceRemoveCompletion();
    }

    public Iterator<Map.Entry<String, JMXEnabledThreadPoolExecutorMBean>> getThreadPoolMBeanProxies() {
        try {
            return new ThreadPoolProxyMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public void getCompactionThreshold(PrintStream outs, String ks, String cf) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        outs.println("Current compaction thresholds for " + ks + "/" + cf + ": \n" + " min = " + cfsProxy.getMinimumCompactionThreshold() + ", " + " max = " + cfsProxy.getMaximumCompactionThreshold());
    }

    public void setCompactionThreshold(String ks, String cf, int minimumCompactionThreshold, int maximumCompactionThreshold) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        cfsProxy.setCompactionThresholds(minimumCompactionThreshold, maximumCompactionThreshold);
    }

    public void setCacheCapacities(int keyCacheCapacity, int rowCacheCapacity) {
        try {
            String keyCachePath = "org.apache.cassandra.db:type=Caches";
            CacheServiceMBean cacheMBean = JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(keyCachePath), CacheServiceMBean.class);
            cacheMBean.setKeyCacheCapacityInMB(keyCacheCapacity);
            cacheMBean.setRowCacheCapacityInMB(rowCacheCapacity);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public List<InetAddress> getEndpoints(String keyspace, String cf, String key) {
        return this.ssProxy.getNaturalEndpoints(keyspace, cf, key);
    }

    public List<String> getSSTables(String keyspace, String cf, String key) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(keyspace, cf);
        return cfsProxy.getSSTablesForKey(key);
    }

    public Set<InetAddress> getStreamDestinations() {
        return this.streamProxy.getStreamDestinations();
    }

    public List<String> getFilesDestinedFor(InetAddress host) throws IOException {
        return this.streamProxy.getOutgoingFiles(host.getHostAddress());
    }

    public Set<InetAddress> getStreamSources() {
        return this.streamProxy.getStreamSources();
    }

    public List<String> getIncomingFiles(InetAddress host) throws IOException {
        return this.streamProxy.getIncomingFiles(host.getHostAddress());
    }

    public String getOperationMode() {
        return this.ssProxy.getOperationMode();
    }

    public void truncate(String tableName, String cfName) {
        try {
            this.ssProxy.truncate(tableName, cfName);
        }
        catch (UnavailableException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
    }

    public EndpointSnitchInfoMBean getEndpointSnitchInfoProxy() {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.db:type=EndpointSnitchInfo"), EndpointSnitchInfoMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnFamilyStoreMBean getCfsProxy(String ks, String cf) {
        ColumnFamilyStoreMBean cfsProxy = null;
        try {
            Set<ObjectName> beans = this.mbeanServerConn.queryNames(new ObjectName("org.apache.cassandra.db:type=*ColumnFamilies,keyspace=" + ks + ",columnfamily=" + cf), null);
            if (beans.isEmpty()) {
                throw new MalformedObjectNameException("couldn't find that bean");
            }
            assert (beans.size() == 1);
            for (ObjectName bean : beans) {
                cfsProxy = JMX.newMBeanProxy(this.mbeanServerConn, bean, ColumnFamilyStoreMBean.class);
            }
        }
        catch (MalformedObjectNameException mone) {
            System.err.println("ColumnFamilyStore for " + ks + "/" + cf + " not found.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("ColumnFamilyStore for " + ks + "/" + cf + " not found: " + e);
            System.exit(1);
        }
        return cfsProxy;
    }

    public StorageProxyMBean getSpProxy() {
        return this.spProxy;
    }

    public String getEndpoint() {
        String stringToken = this.ssProxy.getToken();
        Map<String, String> tokenToEndpoint = this.ssProxy.getTokenToEndpointMap();
        for (Map.Entry<String, String> pair : tokenToEndpoint.entrySet()) {
            if (!pair.getKey().toString().equals(stringToken)) continue;
            return pair.getValue();
        }
        throw new AssertionError((Object)"Could not find myself in the endpoint list, something is very wrong!");
    }

    public String getDataCenter() {
        try {
            return this.getEndpointSnitchInfoProxy().getDatacenter(this.getEndpoint());
        }
        catch (UnknownHostException e) {
            return "Unknown";
        }
    }

    public String getRack() {
        try {
            return this.getEndpointSnitchInfoProxy().getRack(this.getEndpoint());
        }
        catch (UnknownHostException e) {
            return "Unknown";
        }
    }

    public List<String> getKeyspaces() {
        return this.ssProxy.getKeyspaces();
    }

    public void stopGossiping() {
        this.ssProxy.stopGossiping();
    }

    public void startGossiping() {
        this.ssProxy.startGossiping();
    }

    public void stopThriftServer() {
        this.ssProxy.stopRPCServer();
    }

    public void startThriftServer() {
        this.ssProxy.startRPCServer();
    }

    public boolean isThriftServerRunning() {
        return this.ssProxy.isRPCServerRunning();
    }

    public boolean isInitialized() {
        return this.ssProxy.isInitialized();
    }

    public void setCompactionThroughput(int value) {
        this.ssProxy.setCompactionThroughputMbPerSec(value);
    }

    public int getCompactionThroughput() {
        return this.ssProxy.getCompactionThroughputMbPerSec();
    }

    public int getExceptionCount() {
        return this.ssProxy.getExceptionCount();
    }

    public Map<String, Integer> getDroppedMessages() {
        return this.msProxy.getDroppedMessages();
    }

    public void loadNewSSTables(String ksName, String cfName) {
        this.ssProxy.loadNewSSTables(ksName, cfName);
    }

    public void rebuildIndex(String ksName, String cfName, String ... idxNames) {
        this.ssProxy.rebuildSecondaryIndex(ksName, cfName, idxNames);
    }

    public String getGossipInfo() {
        return this.fdProxy.getAllEndpointStates();
    }

    public void stop(String string) {
        this.compactionProxy.stopCompaction(string);
    }

    public void setStreamThroughput(int value) {
        this.ssProxy.setStreamThroughputMbPerSec(value);
    }

    public String getSchemaVersion() {
        return this.ssProxy.getSchemaVersion();
    }

    public List<String> describeRing(String keyspaceName) throws InvalidRequestException {
        return this.ssProxy.describeRingJMX(keyspaceName);
    }

    public void rebuild(String sourceDc) {
        this.ssProxy.rebuild(sourceDc);
    }

    public List<String> sampleKeyRange() {
        return this.ssProxy.sampleKeyRange();
    }

    public void resetLocalSchema() throws IOException {
        this.ssProxy.resetLocalSchema();
    }
}

