/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.ICountableColumnIterator;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.BytesReadTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableIdentityIterator
implements Comparable<SSTableIdentityIterator>,
ICountableColumnIterator {
    private static final Logger logger = LoggerFactory.getLogger(SSTableIdentityIterator.class);
    private final DecoratedKey<?> key;
    private final DataInput input;
    private final long dataStart;
    public final long dataSize;
    public final IColumnSerializer.Flag flag;
    private final ColumnFamily columnFamily;
    private final int columnCount;
    private long columnPosition;
    private BytesReadTracker inputWithTracker;
    private final int expireBefore;
    private final boolean validateColumns;

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey<?> key, long dataStart, long dataSize) throws IOException {
        this(sstable, file, key, dataStart, dataSize, false);
    }

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey<?> key, long dataStart, long dataSize, boolean checkData) throws IOException {
        this(sstable.metadata, file, key, dataStart, dataSize, checkData, sstable, IColumnSerializer.Flag.LOCAL);
    }

    public SSTableIdentityIterator(CFMetaData metadata, DataInput file, DecoratedKey<?> key, long dataStart, long dataSize, IColumnSerializer.Flag flag) throws IOException {
        this(metadata, file, key, dataStart, dataSize, false, null, flag);
    }

    private SSTableIdentityIterator(CFMetaData metadata, DataInput input, DecoratedKey<?> key, long dataStart, long dataSize, boolean checkData, SSTableReader sstable, IColumnSerializer.Flag flag) throws IOException {
        this.input = input;
        this.inputWithTracker = new BytesReadTracker(input);
        this.key = key;
        this.dataStart = dataStart;
        this.dataSize = dataSize;
        this.expireBefore = (int)(System.currentTimeMillis() / 1000L);
        this.flag = flag;
        this.validateColumns = checkData;
        try {
            if (input instanceof RandomAccessReader) {
                RandomAccessReader file = (RandomAccessReader)input;
                file.seek(this.dataStart);
                if (dataStart + dataSize > file.length()) {
                    throw new IOException(String.format("dataSize of %s starting at %s would be larger than file %s length %s", dataSize, dataStart, file.getPath(), file.length()));
                }
                if (checkData) {
                    try {
                        IndexHelper.defreezeBloomFilter(file, dataSize, sstable.descriptor.usesOldBloomFilter);
                    }
                    catch (Exception e) {
                        if (e instanceof EOFException) {
                            throw (EOFException)e;
                        }
                        logger.debug("Invalid bloom filter in {}; will rebuild it", (Object)sstable);
                    }
                    try {
                        IndexHelper.deserializeIndex(file);
                    }
                    catch (Exception e) {
                        logger.debug("Invalid row summary in {}; will rebuild it", (Object)sstable);
                    }
                    file.seek(this.dataStart);
                    this.inputWithTracker.reset(0L);
                }
            }
            IndexHelper.skipBloomFilter(this.inputWithTracker);
            IndexHelper.skipIndex(this.inputWithTracker);
            this.columnFamily = ColumnFamily.create(metadata);
            ColumnFamily.serializer().deserializeFromSSTableNoColumns(this.columnFamily, this.inputWithTracker);
            this.columnCount = this.inputWithTracker.readInt();
            this.columnPosition = dataStart + this.inputWithTracker.getBytesRead();
        }
        catch (IOException e) {
            if (sstable != null) {
                sstable.markSuspect();
            }
            throw new IOError(e);
        }
    }

    @Override
    public DecoratedKey<?> getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public boolean hasNext() {
        return this.inputWithTracker.getBytesRead() < this.dataSize;
    }

    @Override
    public IColumn next() {
        try {
            IColumn column = this.columnFamily.getColumnSerializer().deserialize(this.inputWithTracker, this.flag, this.expireBefore);
            if (this.validateColumns) {
                column.validateFields(this.columnFamily.metadata());
            }
            return column;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (MarshalException e) {
            throw new IOError(new IOException("Error validating row " + this.key, e));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
    }

    public String getPath() {
        if (this.input instanceof RandomAccessReader) {
            RandomAccessReader file = (RandomAccessReader)this.input;
            return file.getPath();
        }
        throw new UnsupportedOperationException();
    }

    public void echoData(DataOutput out) throws IOException {
        if (!(this.input instanceof RandomAccessReader)) {
            throw new UnsupportedOperationException();
        }
        ((RandomAccessReader)this.input).seek(this.dataStart);
        this.inputWithTracker.reset(0L);
        while (this.inputWithTracker.getBytesRead() < this.dataSize) {
            out.write(this.inputWithTracker.readByte());
        }
    }

    public ColumnFamily getColumnFamilyWithColumns() throws IOException {
        assert (this.inputWithTracker.getBytesRead() == this.headerSize());
        ColumnFamily cf = this.columnFamily.cloneMeShallow(ArrayBackedSortedColumns.factory(), false);
        ColumnFamily.serializer().deserializeColumns(this.inputWithTracker, cf, this.columnCount, this.flag);
        if (this.validateColumns) {
            try {
                cf.validateColumnFields();
            }
            catch (MarshalException e) {
                throw new IOException("Error validating row " + this.key, e);
            }
        }
        return cf;
    }

    private long headerSize() {
        return this.columnPosition - this.dataStart;
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }

    @Override
    public void reset() {
        if (!(this.input instanceof RandomAccessReader)) {
            throw new UnsupportedOperationException();
        }
        RandomAccessReader file = (RandomAccessReader)this.input;
        try {
            file.seek(this.columnPosition);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.inputWithTracker.reset(this.headerSize());
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }
}

