/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.EndpointStatesSerializationHelper;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSerializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;

class GossipDigestAckMessageSerializer
implements IVersionedSerializer<GossipDigestAckMessage> {
    GossipDigestAckMessageSerializer() {
    }

    @Override
    public void serialize(GossipDigestAckMessage gDigestAckMessage, DataOutput dos, int version) throws IOException {
        GossipDigestSerializationHelper.serialize(gDigestAckMessage.gDigestList_, dos, version);
        dos.writeBoolean(true);
        EndpointStatesSerializationHelper.serialize(gDigestAckMessage.epStateMap_, dos, version);
    }

    @Override
    public GossipDigestAckMessage deserialize(DataInput dis, int version) throws IOException {
        List<GossipDigest> gDigestList = GossipDigestSerializationHelper.deserialize(dis, version);
        dis.readBoolean();
        Map<InetAddress, EndpointState> epStateMap = EndpointStatesSerializationHelper.deserialize(dis, version);
        return new GossipDigestAckMessage(gDigestList, epStateMap);
    }

    @Override
    public long serializedSize(GossipDigestAckMessage gossipDigestAckMessage, int version) {
        throw new UnsupportedOperationException();
    }
}

