/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance = new CompactionManager();
    public static final int NO_GC = Integer.MIN_VALUE;
    public static final int GC_ALL = Integer.MAX_VALUE;
    private final ReentrantReadWriteLock compactionLock = new ReentrantReadWriteLock();
    private CompactionExecutor executor = new CompactionExecutor();
    private CompactionExecutor validationExecutor = new ValidationExecutor();

    public Lock getCompactionLock() {
        return this.compactionLock.writeLock();
    }

    public Future<?> submitBackground(final ColumnFamilyStore cfs) {
        logger.debug("Scheduling a background task check for {}.{} with {}", new Object[]{cfs.table.name, cfs.columnFamily, cfs.getCompactionStrategy().getClass().getSimpleName()});
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runMayThrow() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    logger.debug("Checking {}.{}", (Object)cfs.table.name, (Object)cfs.columnFamily);
                    if (!cfs.isValid()) {
                        logger.debug("Aborting compaction for dropped CF");
                        return;
                    }
                    AbstractCompactionStrategy strategy = cfs.getCompactionStrategy();
                    AbstractCompactionTask task = strategy.getNextBackgroundTask(CompactionManager.getDefaultGcBefore(cfs));
                    if (task == null) {
                        logger.debug("No tasks available");
                        return;
                    }
                    if (!task.markSSTablesForCompaction()) {
                        logger.debug("Unable to mark SSTables for {}", (Object)task);
                        return;
                    }
                    try {
                        task.execute(CompactionManager.this.executor);
                    }
                    finally {
                        task.unmarkSSTables();
                    }
                    CompactionManager.this.submitBackground(cfs);
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.executor.submit(runnable);
    }

    private void performAllSSTableOperation(final ColumnFamilyStore cfStore, final AllSSTablesOperation operation) throws InterruptedException, ExecutionException {
        Callable<Object> runnable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    Set<SSTableReader> sstables = cfStore.getDataTracker().markCompacting(cfStore.getSSTables(), 1, Integer.MAX_VALUE);
                    if (sstables == null || sstables.isEmpty()) {
                        2 var2_2 = this;
                        return var2_2;
                    }
                    try {
                        CompactionManager.this.compactionLock.readLock().lock();
                        CompactionManager.this.compactionLock.writeLock().unlock();
                        try {
                            operation.perform(cfStore, sstables);
                        }
                        finally {
                            CompactionManager.this.compactionLock.readLock().unlock();
                        }
                    }
                    finally {
                        cfStore.getDataTracker().unmarkCompacting(sstables);
                    }
                    2 var2_3 = this;
                    return var2_3;
                }
                finally {
                    if (CompactionManager.this.compactionLock.writeLock().isHeldByCurrentThread()) {
                        CompactionManager.this.compactionLock.writeLock().unlock();
                    }
                }
            }
        };
        this.executor.submit(runnable).get();
    }

    public void performScrub(ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        this.performAllSSTableOperation(cfStore, new AllSSTablesOperation(){

            @Override
            public void perform(ColumnFamilyStore store, Collection<SSTableReader> sstables) throws IOException {
                CompactionManager.this.doScrub(store, sstables);
            }
        });
    }

    public void performSSTableRewrite(ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        this.performAllSSTableOperation(cfStore, new AllSSTablesOperation(){

            @Override
            public void perform(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) throws IOException {
                assert (!cfs.isIndex());
                for (SSTableReader sstable : sstables) {
                    CompactionTask task = new CompactionTask(cfs, Collections.singletonList(sstable), Integer.MIN_VALUE);
                    task.isUserDefined(true);
                    task.setCompactionType(OperationType.UPGRADE_SSTABLES);
                    task.execute(CompactionManager.this.executor);
                }
            }
        });
    }

    public void performCleanup(ColumnFamilyStore cfStore, final NodeId.OneShotRenewer renewer) throws InterruptedException, ExecutionException {
        this.performAllSSTableOperation(cfStore, new AllSSTablesOperation(){

            @Override
            public void perform(ColumnFamilyStore store, Collection<SSTableReader> sstables) throws IOException {
                CompactionManager.this.doCleanupCompaction(store, sstables, renewer);
            }
        });
    }

    public void performMaximal(ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        this.submitMaximal(cfStore, CompactionManager.getDefaultGcBefore(cfStore)).get();
    }

    public Future<?> submitMaximal(final ColumnFamilyStore cfStore, final int gcBefore) {
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runMayThrow() throws IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    AbstractCompactionTask task = cfStore.getCompactionStrategy().getMaximalTask(gcBefore);
                    if (task == null) {
                        return;
                    }
                    if (!task.markSSTablesForCompaction(0, Integer.MAX_VALUE)) {
                        return;
                    }
                    try {
                        CompactionManager.this.compactionLock.readLock().lock();
                        CompactionManager.this.compactionLock.writeLock().unlock();
                        try {
                            task.execute(CompactionManager.this.executor);
                        }
                        finally {
                            CompactionManager.this.compactionLock.readLock().unlock();
                        }
                    }
                    finally {
                        task.unmarkSSTables();
                    }
                }
                finally {
                    if (CompactionManager.this.compactionLock.writeLock().isHeldByCurrentThread()) {
                        CompactionManager.this.compactionLock.writeLock().unlock();
                    }
                }
            }
        };
        return this.executor.submit(runnable);
    }

    @Override
    public void forceUserDefinedCompaction(String ksname, String dataFiles) {
        if (!Schema.instance.getTables().contains(ksname)) {
            throw new IllegalArgumentException("Unknown keyspace " + ksname);
        }
        File directory = new File(ksname);
        String[] filenames = dataFiles.split(",");
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(filenames.length);
        String cfname = null;
        for (String filename : filenames) {
            Pair<Descriptor, String> p = Descriptor.fromFilename(directory, filename.trim());
            if (!((String)p.right).equals(Component.DATA.name())) {
                throw new IllegalArgumentException(filename + " does not appear to be a data file");
            }
            if (cfname == null) {
                cfname = ((Descriptor)p.left).cfname;
            } else if (!cfname.equals(((Descriptor)p.left).cfname)) {
                throw new IllegalArgumentException("All provided sstables should be for the same column family");
            }
            descriptors.add((Descriptor)p.left);
        }
        ColumnFamilyStore cfs = Table.open(ksname).getColumnFamilyStore(cfname);
        this.submitUserDefined(cfs, descriptors, CompactionManager.getDefaultGcBefore(cfs));
    }

    public Future<?> submitUserDefined(final ColumnFamilyStore cfs, final Collection<Descriptor> dataFiles, final int gcBefore) {
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runMayThrow() throws IOException {
                block13: {
                    CompactionManager.this.compactionLock.readLock().lock();
                    try {
                        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(dataFiles.size());
                        for (Descriptor desc : dataFiles) {
                            SSTableReader sstable = CompactionManager.this.lookupSSTable(cfs, desc);
                            if (sstable == null) {
                                logger.info("Will not compact {}: it is not an active sstable", (Object)desc);
                                continue;
                            }
                            sstables.add(sstable);
                        }
                        try {
                            if (sstables.isEmpty()) {
                                logger.info("No file to compact for user defined compaction");
                                break block13;
                            }
                            Set<SSTableReader> toCompact = cfs.getDataTracker().markCompacting(sstables, 1, Integer.MAX_VALUE);
                            if (toCompact != null) {
                                try {
                                    AbstractCompactionStrategy strategy = cfs.getCompactionStrategy();
                                    AbstractCompactionTask task = strategy.getUserDefinedTask(toCompact, gcBefore);
                                    task.execute(CompactionManager.this.executor);
                                    break block13;
                                }
                                finally {
                                    cfs.getDataTracker().unmarkCompacting(toCompact);
                                }
                            }
                            logger.info("SSTables for user defined compaction are already being compacted.");
                        }
                        finally {
                            SSTableReader.releaseReferences(sstables);
                        }
                    }
                    finally {
                        CompactionManager.this.compactionLock.readLock().unlock();
                    }
                }
            }
        };
        return this.executor.submit(runnable);
    }

    private SSTableReader lookupSSTable(ColumnFamilyStore cfs, Descriptor descriptor) {
        SSTableReader found = null;
        for (SSTableReader sstable : cfs.markCurrentSSTablesReferenced()) {
            if (sstable.descriptor.toString().endsWith(descriptor.toString())) {
                found = sstable;
                continue;
            }
            sstable.releaseReference();
        }
        return found;
    }

    public Future<Object> submitValidation(final ColumnFamilyStore cfStore, final AntiEntropyService.Validator validator) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    CompactionManager.this.doValidationCompaction(cfStore, validator);
                    8 var1_1 = this;
                    return var1_1;
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.validationExecutor.submit(callable);
    }

    public void disableAutoCompaction() {
        for (String ksname : Schema.instance.getNonSystemTables()) {
            for (ColumnFamilyStore cfs : Table.open(ksname).getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    private void doScrub(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) throws IOException {
        assert (!cfs.isIndex());
        for (SSTableReader sstable : sstables) {
            this.scrubOne(cfs, sstable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubOne(ColumnFamilyStore cfs, SSTableReader sstable) throws IOException {
        Scrubber scrubber = new Scrubber(cfs, sstable);
        CompactionInfo.Holder scrubInfo = scrubber.getScrubInfo();
        this.executor.beginCompaction(scrubInfo);
        try {
            scrubber.scrub();
        }
        finally {
            scrubber.close();
            this.executor.finishCompaction(scrubInfo);
        }
        if (scrubber.getNewInOrderSSTable() != null) {
            cfs.addSSTable(scrubber.getNewInOrderSSTable());
        }
        if (scrubber.getNewSSTable() == null) {
            cfs.markCompacted(Collections.singletonList(sstable), OperationType.SCRUB);
        } else {
            cfs.replaceCompactedSSTables(Collections.singletonList(sstable), Collections.singletonList(scrubber.getNewSSTable()), OperationType.SCRUB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanupCompaction(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, NodeId.OneShotRenewer renewer) throws IOException {
        assert (!cfs.isIndex());
        Table table = cfs.table;
        Collection ranges = StorageService.instance.getLocalRanges(table.name);
        if (ranges.isEmpty()) {
            logger.info("Cleanup cannot run before a node has joined the ring");
            return;
        }
        boolean isCommutative = cfs.metadata.getDefaultValidator().isCommutative();
        SortedSet<ByteBuffer> indexedColumns = cfs.indexManager.getIndexedColumns();
        for (SSTableReader sstable : sstables) {
            if (indexedColumns.isEmpty() && !((AbstractBounds)new Bounds(sstable.first.token, sstable.last.token)).intersects(ranges)) {
                cfs.replaceCompactedSSTables(Arrays.asList(sstable), Collections.<SSTableReader>emptyList(), OperationType.CLEANUP);
                continue;
            }
            CompactionController controller = new CompactionController(cfs, Collections.singletonList(sstable), CompactionManager.getDefaultGcBefore(cfs), false);
            long startTime = System.currentTimeMillis();
            long totalkeysWritten = 0L;
            int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(Arrays.asList(sstable)));
            if (logger.isDebugEnabled()) {
                logger.debug("Expected bloom filter size : " + expectedBloomFilterSize);
            }
            SSTableWriter writer = null;
            SSTableReader newSstable = null;
            logger.info("Cleaning up " + sstable);
            long expectedRangeFileSize = cfs.getExpectedCompactedFileSize(Arrays.asList(sstable), OperationType.CLEANUP);
            File compactionFileLocation = cfs.directories.getDirectoryForNewSSTables(expectedRangeFileSize);
            if (compactionFileLocation == null) {
                throw new IOException("disk full");
            }
            SSTableScanner scanner = sstable.getDirectScanner();
            long rowsRead = 0L;
            ArrayList<IColumn> indexedColumnsInRow = null;
            CleanupInfo ci = new CleanupInfo(sstable, scanner);
            this.executor.beginCompaction(ci);
            try {
                while (scanner.hasNext()) {
                    if (ci.isStopRequested()) {
                        throw new CompactionInterruptedException(ci.getCompactionInfo());
                    }
                    SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
                    if (Range.isInRanges(row.getKey().token, ranges)) {
                        AbstractCompactedRow compactedRow = controller.getCompactedRow(row);
                        if (compactedRow.isEmpty()) continue;
                        writer = CompactionManager.maybeCreateWriter(cfs, compactionFileLocation, expectedBloomFilterSize, writer, Collections.singletonList(sstable));
                        writer.append(compactedRow);
                        ++totalkeysWritten;
                    } else {
                        cfs.invalidateCachedRow(row.getKey());
                        if (!indexedColumns.isEmpty() || isCommutative) {
                            if (indexedColumnsInRow != null) {
                                indexedColumnsInRow.clear();
                            }
                            while (row.hasNext()) {
                                IColumn column = row.next();
                                if (column instanceof CounterColumn) {
                                    renewer.maybeRenew((CounterColumn)column);
                                }
                                if (!indexedColumns.contains(column.name())) continue;
                                if (indexedColumnsInRow == null) {
                                    indexedColumnsInRow = new ArrayList<IColumn>();
                                }
                                indexedColumnsInRow.add(column);
                            }
                            if (indexedColumnsInRow != null && !indexedColumnsInRow.isEmpty()) {
                                Table.switchLock.readLock().lock();
                                try {
                                    cfs.indexManager.deleteFromIndexes(row.getKey(), (List<IColumn>)indexedColumnsInRow);
                                }
                                finally {
                                    Table.switchLock.readLock().unlock();
                                }
                            }
                        }
                    }
                    if (rowsRead++ % 1000L != 0L) continue;
                    controller.mayThrottle(scanner.getCurrentPosition());
                }
                if (writer != null) {
                    newSstable = writer.closeAndOpenReader(sstable.maxDataAge);
                }
            }
            catch (Exception e) {
                if (writer != null) {
                    writer.abort();
                }
                throw FBUtilities.unchecked(e);
            }
            finally {
                scanner.close();
                this.executor.finishCompaction(ci);
            }
            ArrayList<SSTableReader> results = new ArrayList<SSTableReader>(1);
            if (newSstable != null) {
                results.add(newSstable);
                String format = "Cleaned up to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.";
                long dTime = System.currentTimeMillis() - startTime;
                long startsize = sstable.onDiskLength();
                long endsize = newSstable.onDiskLength();
                double ratio = (double)endsize / (double)startsize;
                logger.info(String.format(format, writer.getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
            }
            cfs.indexManager.flushIndexesBlocking();
            cfs.replaceCompactedSSTables(Arrays.asList(sstable), results, OperationType.CLEANUP);
        }
    }

    public static SSTableWriter maybeCreateWriter(ColumnFamilyStore cfs, File compactionFileLocation, int expectedBloomFilterSize, SSTableWriter writer, Collection<SSTableReader> sstables) throws IOException {
        if (writer == null) {
            FileUtils.createDirectory(compactionFileLocation);
            writer = cfs.createCompactionWriter(expectedBloomFilterSize, compactionFileLocation, sstables);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidationCompaction(ColumnFamilyStore cfs, AntiEntropyService.Validator validator) throws IOException {
        Collection<SSTableReader> sstables;
        if (!cfs.isValid()) {
            return;
        }
        if (cfs.table.snapshotExists(validator.request.sessionid)) {
            sstables = cfs.getSnapshotSSTableReader(validator.request.sessionid);
        } else {
            try {
                StorageService.instance.forceTableFlush(cfs.table.name, cfs.getColumnFamilyName());
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            sstables = cfs.markCurrentSSTablesReferenced();
        }
        ValidationCompactionIterable ci = new ValidationCompactionIterable(cfs, sstables, validator.request.range);
        Iterator iter = ci.iterator();
        this.validationExecutor.beginCompaction(ci);
        try {
            UnmodifiableIterator nni = Iterators.filter((Iterator)iter, (Predicate)Predicates.notNull());
            validator.prepare(cfs);
            while (nni.hasNext()) {
                if (ci.isStopRequested()) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                validator.add(row);
            }
            validator.complete();
        }
        finally {
            SSTableReader.releaseReferences(sstables);
            iter.close();
            if (cfs.table.snapshotExists(validator.request.sessionid)) {
                cfs.table.clearSnapshot(validator.request.sessionid);
            }
            this.validationExecutor.finishCompaction(ci);
        }
    }

    public Future<?> submitIndexBuild(final SecondaryIndexBuilder builder) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    CompactionManager.this.executor.beginCompaction(builder);
                    try {
                        builder.build();
                    }
                    finally {
                        CompactionManager.this.executor.finishCompaction(builder);
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        if (this.compactionLock.isWriteLockedByCurrentThread()) {
            return new SimpleFuture(runnable);
        }
        return this.executor.submit(runnable);
    }

    public Future<?> submitCacheWrite(final AutoSavingCache.Writer writer) {
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMayThrow() throws IOException {
                if (!AutoSavingCache.flushInProgress.add(writer.cacheType())) {
                    logger.debug("Cache flushing was already in progress: skipping {}", (Object)writer.getCompactionInfo());
                    return;
                }
                try {
                    CompactionManager.this.executor.beginCompaction(writer);
                    try {
                        writer.saveCache();
                    }
                    finally {
                        CompactionManager.this.executor.finishCompaction(writer);
                    }
                }
                finally {
                    AutoSavingCache.flushInProgress.remove((Object)writer.cacheType());
                }
            }
        };
        return this.executor.submit(runnable);
    }

    public Future<?> submitTruncate(final ColumnFamilyStore main, final long truncatedAt) {
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMayThrow() throws InterruptedException, IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    main.discardSSTables(truncatedAt);
                    for (SecondaryIndex index : main.indexManager.getIndexes()) {
                        index.truncate(truncatedAt);
                    }
                    for (RowCacheKey key : CacheService.instance.rowCache.getKeySet()) {
                        if (key.cfId != main.metadata.cfId) continue;
                        CacheService.instance.rowCache.remove(key);
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.writeLock().unlock();
                }
            }
        };
        return this.executor.submit(runnable);
    }

    static int getDefaultGcBefore(ColumnFamilyStore cfs) {
        return cfs.isIndex() ? Integer.MAX_VALUE : (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds();
    }

    public int getActiveCompactions() {
        return CompactionExecutor.compactions.size();
    }

    @Override
    public List<Map<String, String>> getCompactions() {
        List<CompactionInfo.Holder> compactionHolders = CompactionExecutor.getCompactions();
        ArrayList<Map<String, String>> out = new ArrayList<Map<String, String>>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().asMap());
        }
        return out;
    }

    @Override
    public List<String> getCompactionSummary() {
        List<CompactionInfo.Holder> compactionHolders = CompactionExecutor.getCompactions();
        ArrayList<String> out = new ArrayList<String>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().toString());
        }
        return out;
    }

    @Override
    public long getTotalBytesCompacted() {
        return this.executor.getTotalBytesCompacted() + this.validationExecutor.getTotalBytesCompacted();
    }

    @Override
    public long getTotalCompactionsCompleted() {
        return this.executor.getTotalCompactionsCompleted() + this.validationExecutor.getTotalCompactionsCompleted();
    }

    @Override
    public int getPendingTasks() {
        int n = 0;
        for (String tableName : Schema.instance.getTables()) {
            for (ColumnFamilyStore cfs : Table.open(tableName).getColumnFamilyStores()) {
                n += cfs.getCompactionStrategy().getEstimatedRemainingTasks();
            }
        }
        return (int)(this.executor.getTaskCount() + this.validationExecutor.getTaskCount() - this.executor.getCompletedTaskCount() - this.validationExecutor.getCompletedTaskCount()) + n;
    }

    @Override
    public long getCompletedTasks() {
        return this.executor.getCompletedTaskCount() + this.validationExecutor.getCompletedTaskCount();
    }

    @Override
    public void stopCompaction(String type) {
        OperationType operation = OperationType.valueOf(type);
        for (CompactionInfo.Holder holder : CompactionExecutor.getCompactions()) {
            if (holder.getCompactionInfo().getTaskType() != operation) continue;
            holder.stop();
        }
    }

    public void stopCompactionFor(Collection<CFMetaData> columnFamilies) {
        assert (columnFamilies != null);
        for (CompactionInfo.Holder compactionHolder : CompactionExecutor.getCompactions()) {
            CompactionInfo info = compactionHolder.getCompactionInfo();
            if (!columnFamilies.contains(info.getCFMetaData())) continue;
            compactionHolder.stop();
        }
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class CleanupInfo
    extends CompactionInfo.Holder {
        private final SSTableReader sstable;
        private final SSTableScanner scanner;

        public CleanupInfo(SSTableReader sstable, SSTableScanner scanner) {
            this.sstable = sstable;
            this.scanner = scanner;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.sstable.metadata, OperationType.CLEANUP, this.scanner.getCurrentPosition(), this.scanner.getLengthInBytes());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private static class SimpleFuture
    implements Future {
        private Runnable runnable;

        private SimpleFuture(Runnable r) {
            this.runnable = r;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new IllegalStateException("May not call SimpleFuture.cancel()");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.runnable == null;
        }

        public Object get() throws InterruptedException, ExecutionException {
            this.runnable.run();
            this.runnable = null;
            return this.runnable;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new IllegalStateException("May not call SimpleFuture.get(long, TimeUnit)");
        }
    }

    public static interface CompactionExecutorStatsCollector {
        public void beginCompaction(CompactionInfo.Holder var1);

        public void finishCompaction(CompactionInfo.Holder var1);
    }

    private static class ValidationExecutor
    extends CompactionExecutor {
        public ValidationExecutor() {
            super(1, Integer.MAX_VALUE, "ValidationExecutor", new SynchronousQueue<Runnable>());
        }
    }

    private static class CompactionExecutor
    extends ThreadPoolExecutor
    implements CompactionExecutorStatsCollector {
        private static final Set<CompactionInfo.Holder> compactions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
        private volatile long totalBytesCompacted = 0L;
        private volatile long totalCompactionsCompleted = 0L;

        protected CompactionExecutor(int minThreads, int maxThreads, String name, BlockingQueue<Runnable> queue) {
            super(minThreads, maxThreads, 60L, TimeUnit.SECONDS, queue, new NamedThreadFactory(name, 1));
            this.allowCoreThreadTimeOut(true);
        }

        private CompactionExecutor(int threadCount, String name) {
            this(threadCount, threadCount, name, new LinkedBlockingQueue<Runnable>());
        }

        public CompactionExecutor() {
            this(Math.max(1, DatabaseDescriptor.getConcurrentCompactors()), "CompactionExecutor");
        }

        @Override
        public void beginCompaction(CompactionInfo.Holder ci) {
            compactions.add(ci);
        }

        @Override
        public void finishCompaction(CompactionInfo.Holder ci) {
            compactions.remove(ci);
            this.totalBytesCompacted += ci.getCompactionInfo().getTotalBytes();
            ++this.totalCompactionsCompleted;
        }

        public static List<CompactionInfo.Holder> getCompactions() {
            return new ArrayList<CompactionInfo.Holder>(compactions);
        }

        public long getTotalBytesCompacted() {
            long bytesCompletedInProgress = 0L;
            for (CompactionInfo.Holder ci : compactions) {
                bytesCompletedInProgress += ci.getCompactionInfo().getBytesComplete();
            }
            return bytesCompletedInProgress + this.totalBytesCompacted;
        }

        public long getTotalCompactionsCompleted() {
            return this.totalCompactionsCompleted;
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t == null) {
                t = DebuggableThreadPoolExecutor.extractThrowable(r);
            }
            if (t != null) {
                if (t instanceof CompactionInterruptedException) {
                    logger.info(t.getMessage());
                    logger.debug("Full interruption stack trace:", t);
                } else {
                    DebuggableThreadPoolExecutor.handleOrLog(t);
                }
            }
        }
    }

    private static class ValidationCompactionController
    extends CompactionController {
        public ValidationCompactionController(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) {
            super(cfs, Integer.MIN_VALUE, true, null, cfs.getCompactionStrategy().isKeyExistenceExpensive((Set<? extends SSTable>)ImmutableSet.copyOf(sstables)));
        }

        @Override
        public boolean shouldPurge(DecoratedKey key) {
            return false;
        }
    }

    private static class ValidationCompactionIterable
    extends CompactionIterable {
        public ValidationCompactionIterable(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, Range<Token> range) throws IOException {
            super(OperationType.VALIDATION, cfs.getCompactionStrategy().getScanners(sstables, range), new ValidationCompactionController(cfs, sstables));
        }
    }

    private static interface AllSSTablesOperation {
        public void perform(ColumnFamilyStore var1, Collection<SSTableReader> var2) throws IOException;
    }
}

