/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CFPropDefs;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.commons.lang.StringUtils;

public class CreateColumnFamilyStatement
extends SchemaAlteringStatement {
    private AbstractType<?> comparator;
    private AbstractType<?> defaultValidator;
    private AbstractType<?> keyValidator;
    private ByteBuffer keyAlias;
    private List<ByteBuffer> columnAliases = new ArrayList<ByteBuffer>();
    private ByteBuffer valueAlias;
    private final Map<ColumnIdentifier, AbstractType> columns = new HashMap<ColumnIdentifier, AbstractType>();
    private final CFPropDefs properties;

    public CreateColumnFamilyStatement(CFName name, CFPropDefs properties) {
        super(name);
        this.properties = properties;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.WRITE);
    }

    private Map<ByteBuffer, ColumnDefinition> getColumns() throws InvalidRequestException {
        HashMap<ByteBuffer, ColumnDefinition> columnDefs = new HashMap<ByteBuffer, ColumnDefinition>();
        Integer componentIndex = this.comparator instanceof CompositeType ? Integer.valueOf(((CompositeType)this.comparator).types.size() - 1) : null;
        for (Map.Entry<ColumnIdentifier, AbstractType> col : this.columns.entrySet()) {
            columnDefs.put(col.getKey().key, new ColumnDefinition(col.getKey().key, col.getValue(), null, null, null, componentIndex));
        }
        return columnDefs;
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        MigrationManager.announceNewColumnFamily(this.getCFMetaData());
    }

    public CFMetaData getCFMetaData() throws InvalidRequestException {
        CFMetaData newCFMD;
        try {
            newCFMD = new CFMetaData(this.keyspace(), this.columnFamily(), ColumnFamilyType.Standard, this.comparator, null);
            this.applyPropertiesTo(newCFMD);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        return newCFMD;
    }

    public void applyPropertiesTo(CFMetaData cfmd) throws InvalidRequestException, ConfigurationException {
        cfmd.defaultValidator(this.defaultValidator).columnMetadata(this.getColumns()).keyValidator(this.keyValidator).keyAlias(this.keyAlias).columnAliases(this.columnAliases).valueAlias(this.valueAlias);
        this.properties.applyToCFMetadata(cfmd);
    }

    public static class RawStatement
    extends CFStatement {
        private final Map<ColumnIdentifier, String> definitions = new HashMap<ColumnIdentifier, String>();
        private final CFPropDefs properties = new CFPropDefs();
        private final List<ColumnIdentifier> keyAliases = new ArrayList<ColumnIdentifier>();
        private final List<ColumnIdentifier> columnAliases = new ArrayList<ColumnIdentifier>();
        private final Map<ColumnIdentifier, Boolean> definedOrdering = new HashMap<ColumnIdentifier, Boolean>();
        private boolean useCompactStorage;
        private Multiset<ColumnIdentifier> definedNames = HashMultiset.create((int)1);

        public RawStatement(CFName name) {
            super(name);
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            try {
                if (!this.columnFamily().matches("\\w+")) {
                    throw new InvalidRequestException(String.format("\"%s\" is not a valid column family name (must be alphanumeric character only: [0-9A-Za-z]+)", this.columnFamily()));
                }
                if (this.columnFamily().length() > 48) {
                    throw new InvalidRequestException(String.format("Column family names shouldn't be more than %s characters long (got \"%s\")", 48, this.columnFamily()));
                }
                for (Multiset.Entry entry : this.definedNames.entrySet()) {
                    if (entry.getCount() <= 1) continue;
                    throw new InvalidRequestException(String.format("Multiple definition of identifier %s", entry.getElement()));
                }
                this.properties.validate();
                CreateColumnFamilyStatement stmt = new CreateColumnFamilyStatement(this.cfName, this.properties);
                stmt.setBoundTerms(this.getBoundsTerms());
                for (Map.Entry<ColumnIdentifier, String> entry : this.definitions.entrySet()) {
                    AbstractType<?> type = CFPropDefs.parseType(entry.getValue());
                    stmt.columns.put(entry.getKey(), type);
                }
                if (this.keyAliases.size() == 0) {
                    throw new InvalidRequestException("You must specify a PRIMARY KEY");
                }
                if (this.keyAliases.size() > 1) {
                    throw new InvalidRequestException("You may only specify one PRIMARY KEY");
                }
                stmt.keyAlias = this.keyAliases.get((int)0).key;
                stmt.keyValidator = this.getTypeAndRemove(stmt.columns, this.keyAliases.get(0));
                if (stmt.keyValidator instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", stmt.keyAlias));
                }
                if (this.columnAliases != null && !this.columnAliases.isEmpty()) {
                    if (this.useCompactStorage && this.columnAliases.size() == 1) {
                        stmt.columnAliases.add(this.columnAliases.get((int)0).key);
                        stmt.comparator = this.getTypeAndRemove(stmt.columns, this.columnAliases.get(0));
                        if (stmt.comparator instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", stmt.columnAliases.get(0)));
                        }
                    } else {
                        ArrayList types = new ArrayList(this.columnAliases.size() + 1);
                        for (ColumnIdentifier t : this.columnAliases) {
                            stmt.columnAliases.add(t.key);
                            AbstractType<?> type = this.getTypeAndRemove(stmt.columns, t);
                            if (type instanceof CounterColumnType) {
                                throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", t.key));
                            }
                            types.add(type);
                        }
                        if (!this.useCompactStorage) {
                            types.add(CFDefinition.definitionType);
                        }
                        if (types.isEmpty()) {
                            throw new IllegalStateException("Nonsensical empty parameter list for CompositeType");
                        }
                        stmt.comparator = CompositeType.getInstance(types);
                    }
                } else {
                    stmt.comparator = CFDefinition.definitionType;
                }
                if (this.useCompactStorage && !stmt.columnAliases.isEmpty()) {
                    if (stmt.columns.isEmpty()) {
                        throw new InvalidRequestException("COMPACT STORAGE requires one definition not part of the PRIMARY KEY, none found");
                    }
                    if (stmt.columns.size() > 1) {
                        throw new InvalidRequestException(String.format("COMPACT STORAGE allows only one column not part of the PRIMARY KEY (got: %s)", StringUtils.join(stmt.columns.keySet(), (String)", ")));
                    }
                    Map.Entry lastEntry = stmt.columns.entrySet().iterator().next();
                    stmt.defaultValidator = (AbstractType)lastEntry.getValue();
                    stmt.valueAlias = ((ColumnIdentifier)lastEntry.getKey()).key;
                    stmt.columns.remove(lastEntry.getKey());
                } else {
                    if (stmt.columns.isEmpty()) {
                        throw new InvalidRequestException("No definition found that is not part of the PRIMARY KEY");
                    }
                    stmt.defaultValidator = stmt.columns.values().iterator().next() instanceof CounterColumnType ? CounterColumnType.instance : CFDefinition.definitionType;
                }
                return new ParsedStatement.Prepared(stmt);
            }
            catch (ConfigurationException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        private AbstractType<?> getTypeAndRemove(Map<ColumnIdentifier, AbstractType> columns, ColumnIdentifier t) throws InvalidRequestException, ConfigurationException {
            ReversedType type = columns.get(t);
            if (type == null) {
                throw new InvalidRequestException(String.format("Unkown definition %s referenced in PRIMARY KEY", t));
            }
            columns.remove(t);
            Boolean isReversed = this.definedOrdering.get(t);
            return isReversed != null && isReversed != false ? ReversedType.getInstance(type) : type;
        }

        public void addDefinition(ColumnIdentifier def, String type) {
            this.definedNames.add((Object)def);
            this.definitions.put(def, type);
        }

        public void setKeyAlias(ColumnIdentifier alias) {
            this.keyAliases.add(alias);
        }

        public void addColumnAlias(ColumnIdentifier alias) {
            this.columnAliases.add(alias);
        }

        public void addProperty(String name, String value) throws InvalidRequestException {
            this.properties.addProperty(name, value);
        }

        public void setOrdering(ColumnIdentifier alias, boolean reversed) {
            this.definedOrdering.put(alias, reversed);
        }

        public void setCompactStorage() {
            this.useCompactStorage = true;
        }

        public void checkAccess(ClientState state) {
            throw new UnsupportedOperationException();
        }

        public CqlResult execute(ClientState state, List<ByteBuffer> variables) {
            throw new UnsupportedOperationException();
        }
    }
}

