/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.cql3.PropertyDefinitions;
import org.apache.cassandra.thrift.InvalidRequestException;

public class KSPropDefs
extends PropertyDefinitions {
    public static final String KW_DURABLE_WRITES = "durable_writes";
    public static final String KW_REPLICATION_STRATEGY = "strategy_class";
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    private String strategyClass;
    private final Map<String, String> strategyOptions = new HashMap<String, String>();

    public void validate() throws ConfigurationException, InvalidRequestException {
        this.validate(keywords, obsoleteKeywords);
        if (!this.properties.containsKey(KW_REPLICATION_STRATEGY)) {
            throw new InvalidRequestException("missing required argument \"strategy_class\"");
        }
        this.strategyClass = (String)this.properties.get(KW_REPLICATION_STRATEGY);
    }

    @Override
    public void addProperty(String name, String value) throws InvalidRequestException {
        if (name.contains(":") && name.startsWith("strategy_options")) {
            this.strategyOptions.put(name.split(":")[1], value);
        } else {
            super.addProperty(name, value);
        }
    }

    public String getReplicationStrategyClass() {
        return this.strategyClass;
    }

    public Map<String, String> getReplicationOptions() {
        return this.strategyOptions;
    }

    public KSMetaData asKSMetadata(String ksName) throws InvalidRequestException, ConfigurationException {
        return KSMetaData.newKeyspace(ksName, this.getReplicationStrategyClass(), this.getReplicationOptions(), this.getBoolean(KW_DURABLE_WRITES, true));
    }

    public KSMetaData asKSMetadataUpdate(KSMetaData old) throws InvalidRequestException, ConfigurationException {
        String sClass = this.strategyClass;
        Map<String, String> sOptions = this.getReplicationOptions();
        if (sClass == null) {
            sClass = old.strategyClass.getName();
            sOptions = old.strategyOptions;
        }
        return KSMetaData.newKeyspace(old.name, sClass, sOptions, this.getBoolean(KW_DURABLE_WRITES, old.durableWrites));
    }

    static {
        keywords.add(KW_DURABLE_WRITES);
        keywords.add(KW_REPLICATION_STRATEGY);
    }
}

