/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.ThriftValidation;

public class DropKeyspaceStatement
extends SchemaAlteringStatement {
    private final String keyspace;

    public DropKeyspaceStatement(String keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace, Permission.DROP);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException, SchemaDisagreementException {
        super.validate(state);
        ThriftValidation.validateKeyspaceNotSystem(this.keyspace);
    }

    @Override
    public void announceMigration() throws ConfigurationException {
        MigrationManager.announceKeyspaceDrop(this.keyspace);
    }
}

