/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.KSPropDefs;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.ThriftValidation;

public class CreateKeyspaceStatement
extends SchemaAlteringStatement {
    private final String name;
    private final KSPropDefs attrs;

    public CreateKeyspaceStatement(String name, KSPropDefs attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        state.hasKeyspaceAccess(this.name, Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException, SchemaDisagreementException {
        super.validate(state);
        ThriftValidation.validateKeyspaceNotSystem(this.name);
        if (!this.name.matches("\\w+")) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid keyspace name", this.name));
        }
        if (this.name.length() > 48) {
            throw new InvalidRequestException(String.format("Keyspace names shouldn't be more than %s characters long (got \"%s\")", 48, this.name));
        }
        try {
            this.attrs.validate();
            if (this.attrs.getReplicationStrategyClass() == null) {
                throw new ConfigurationException("Missing mandatory replication strategy class");
            }
            AbstractReplicationStrategy.createReplicationStrategy(this.name, AbstractReplicationStrategy.getClass(this.attrs.getReplicationStrategyClass()), StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), this.attrs.getReplicationOptions());
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        ThriftValidation.validateKeyspaceNotYetExisting(this.name);
        MigrationManager.announceNewKeyspace(this.attrs.asKSMetadata(this.name));
    }
}

