/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.IRowCacheProvider;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.cache.SerializingCache;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.io.ISerializer;

public class SerializingCacheProvider
implements IRowCacheProvider {
    @Override
    public ICache<RowCacheKey, IRowCacheEntry> create(long capacity, boolean useMemoryWeigher) {
        return new SerializingCache<RowCacheKey, IRowCacheEntry>(capacity, useMemoryWeigher, new RowCacheSerializer());
    }

    private static class RowCacheSerializer
    implements ISerializer<IRowCacheEntry> {
        private RowCacheSerializer() {
        }

        @Override
        public void serialize(IRowCacheEntry cf, DataOutput out) {
            assert (cf != null);
            try {
                out.writeBoolean(cf instanceof RowCacheSentinel);
                if (cf instanceof RowCacheSentinel) {
                    out.writeLong(((RowCacheSentinel)cf).sentinelId);
                } else {
                    ColumnFamily.serializer.serialize((ColumnFamily)cf, out);
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public IRowCacheEntry deserialize(DataInput in) throws IOException {
            boolean isSentinel = in.readBoolean();
            if (isSentinel) {
                return new RowCacheSentinel(in.readLong());
            }
            return ColumnFamily.serializer.deserialize(in);
        }

        @Override
        public long serializedSize(IRowCacheEntry cf) {
            return 1L + (cf instanceof RowCacheSentinel ? 12L : ColumnFamily.serializer().serializedSize((ColumnFamily)cf));
        }
    }
}

