/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthority;
import org.apache.cassandra.auth.IAuthority2;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;

public class IAuthorityContainer {
    private final IAuthority authority;
    private final IAuthority2 dynamicAuthority;

    public IAuthorityContainer(IAuthority authority) {
        this.authority = authority;
        this.dynamicAuthority = authority instanceof IAuthority2 ? (IAuthority2)authority : null;
    }

    public void setup() {
        if (this.dynamicAuthority != null) {
            this.dynamicAuthority.setup();
        }
    }

    public boolean isDynamic() {
        return this.dynamicAuthority != null;
    }

    public IAuthority getAuthority() {
        return this.authority;
    }

    public void grant(AuthenticatedUser granter, Permission permission, String to, CFName resource, boolean grantOption) throws InvalidRequestException {
        if (this.dynamicAuthority == null) {
            throw new InvalidRequestException("GRANT operation is not supported by your authority: " + this.authority);
        }
        if (permission.equals((Object)Permission.READ) || permission.equals((Object)Permission.WRITE)) {
            throw new InvalidRequestException(String.format("Error setting permission to: %s, available permissions are %s", new Object[]{permission, Permission.GRANULAR_PERMISSIONS}));
        }
        this.dynamicAuthority.grant(granter, permission, to, resource, grantOption);
    }

    public void revoke(AuthenticatedUser revoker, Permission permission, String from, CFName resource) throws InvalidRequestException {
        if (this.dynamicAuthority == null) {
            throw new InvalidRequestException("REVOKE operation is not supported by your authority: " + this.authority);
        }
        this.dynamicAuthority.revoke(revoker, permission, from, resource);
    }

    public CqlResult listPermissions(String username) throws InvalidRequestException {
        if (this.dynamicAuthority == null) {
            throw new InvalidRequestException("LIST GRANTS operation is not supported by your authority: " + this.authority);
        }
        return this.dynamicAuthority.listPermissions(username);
    }
}

