/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompositeType
extends AbstractCompositeType {
    public final List<AbstractType<?>> types;
    private static final Map<List<AbstractType<?>>, CompositeType> instances = new HashMap();

    public static CompositeType getInstance(TypeParser parser) throws ConfigurationException {
        return CompositeType.getInstance(parser.getTypeParameters());
    }

    public static synchronized CompositeType getInstance(List<AbstractType<?>> types) {
        assert (types != null && !types.isEmpty());
        CompositeType ct = instances.get(types);
        if (ct == null) {
            ct = new CompositeType(types);
            instances.put(types, ct);
        }
        return ct;
    }

    private CompositeType(List<AbstractType<?>> types) {
        this.types = types;
    }

    @Override
    protected AbstractType<?> getNextComparator(int i, ByteBuffer bb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractType<?> getNextComparator(int i, ByteBuffer bb1, ByteBuffer bb2) {
        return this.types.get(i);
    }

    @Override
    protected AbstractType<?> getAndAppendNextComparator(int i, ByteBuffer bb, StringBuilder sb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseNextComparator(int i, String part) {
        return new StaticParsedComparator(this.types.get(i), part);
    }

    @Override
    protected AbstractType<?> validateNextComparator(int i, ByteBuffer bb) throws MarshalException {
        if (i >= this.types.size()) {
            throw new MarshalException("Too many bytes for comparator");
        }
        return this.types.get(i);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)previous;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }

    public static class Builder
    implements ColumnNameBuilder {
        private final CompositeType composite;
        private int current;
        private final DataOutputBuffer out = new DataOutputBuffer();

        public Builder(CompositeType composite) {
            this.composite = composite;
        }

        private Builder(Builder b) {
            this(b.composite);
            this.current = b.current;
            this.out.write(b.out.getData(), 0, b.out.getLength());
        }

        @Override
        public Builder add(Term t, Relation.Type op, List<ByteBuffer> variables) throws InvalidRequestException {
            if (this.current >= this.composite.types.size()) {
                throw new IllegalStateException("Composite column is already fully constructed");
            }
            AbstractType<?> currentType = this.composite.types.get(this.current++);
            ByteBuffer buffer = t.getByteBuffer(currentType, variables);
            ByteBufferUtil.writeWithShortLength(buffer, this.out);
            switch (op) {
                case LT: {
                    this.out.write(-1);
                    break;
                }
                case GT: 
                case LTE: {
                    this.out.write(1);
                    break;
                }
                default: {
                    this.out.write(0);
                }
            }
            return this;
        }

        @Override
        public Builder add(ByteBuffer bb) {
            if (this.current >= this.composite.types.size()) {
                throw new IllegalStateException("Composite column is already fully constructed");
            }
            ByteBufferUtil.writeWithShortLength(bb, this.out);
            this.out.write(0);
            return this;
        }

        @Override
        public int componentCount() {
            return this.current;
        }

        @Override
        public ByteBuffer build() {
            return ByteBuffer.wrap(this.out.getData(), 0, this.out.getLength());
        }

        @Override
        public ByteBuffer buildAsEndOfRange() {
            if (this.current >= this.composite.types.size()) {
                throw new IllegalStateException("Composite column is already fully constructed");
            }
            if (this.current == 0) {
                return ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            ByteBuffer bb = this.build();
            bb.put(bb.remaining() - 1, (byte)1);
            return bb;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }
    }

    private static class StaticParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final String part;

        StaticParsedComparator(AbstractType<?> type, String part) {
            this.type = type;
            this.part = part;
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.part;
        }

        @Override
        public int getComparatorSerializedSize() {
            return 0;
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
        }
    }
}

