/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CFPropDefs;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.ThriftValidation;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final String validator;
    public final ColumnIdentifier columnName;
    private final CFPropDefs cfProps = new CFPropDefs();

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier columnName, String validator, Map<String, String> propertyMap) {
        super(name);
        this.oType = type;
        this.columnName = columnName;
        this.validator = validator;
        this.cfProps.addAll(propertyMap);
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CFMetaData cfm = meta.clone();
        CFDefinition cfDef = meta.getCfDef();
        CFDefinition.Name name = this.oType == Type.OPTS ? null : cfDef.get(this.columnName);
        switch (this.oType) {
            case ADD: {
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot add new column to a compact CF");
                }
                if (name != null) {
                    switch (name.kind) {
                        case KEY_ALIAS: 
                        case COLUMN_ALIAS: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", this.columnName));
                        }
                        case COLUMN_METADATA: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", this.columnName));
                        }
                    }
                }
                cfm.addColumnDefinition(new ColumnDefinition(this.columnName.key, CFPropDefs.parseType(this.validator), null, null, null, cfDef.isComposite ? Integer.valueOf(((CompositeType)meta.comparator).types.size() - 1) : null));
                break;
            }
            case ALTER: {
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in CF %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        AbstractType<?> newType = CFPropDefs.parseType(this.validator);
                        if (newType instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", this.columnName));
                        }
                        cfm.keyValidator(newType);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        assert (cfDef.isComposite);
                        ArrayList newTypes = new ArrayList(((CompositeType)cfm.comparator).types);
                        newTypes.set(name.position, CFPropDefs.parseType(this.validator));
                        cfm.comparator = CompositeType.getInstance(newTypes);
                        break;
                    }
                    case VALUE_ALIAS: {
                        cfm.defaultValidator(CFPropDefs.parseType(this.validator));
                        break;
                    }
                    case COLUMN_METADATA: {
                        ColumnDefinition column = cfm.getColumnDefinition(this.columnName.key);
                        column.setValidator(CFPropDefs.parseType(this.validator));
                        cfm.addColumnDefinition(column);
                    }
                }
                break;
            }
            case DROP: {
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot drop columns from a compact CF");
                }
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in CF %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", this.columnName));
                    }
                    case COLUMN_METADATA: {
                        ColumnDefinition toDelete = null;
                        for (ColumnDefinition columnDef : cfm.getColumn_metadata().values()) {
                            if (!columnDef.name.equals(this.columnName.key)) continue;
                            toDelete = columnDef;
                        }
                        assert (toDelete != null);
                        cfm.removeColumnDefinition(toDelete);
                    }
                }
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                this.cfProps.applyToCFMetadata(cfm);
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm);
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.columnName, this.validator});
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS;

    }
}

