/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class RowCacheKey
implements CacheKey,
Comparable<RowCacheKey> {
    public final int cfId;
    public final byte[] key;

    public RowCacheKey(int cfId, DecoratedKey key) {
        this(cfId, key.key);
    }

    public RowCacheKey(int cfId, ByteBuffer key) {
        this.cfId = cfId;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        ByteBufferUtil.writeWithLength(this.key, (DataOutput)out);
    }

    @Override
    public Pair<String, String> getPathInfo() {
        return Schema.instance.getCF(this.cfId);
    }

    @Override
    public int serializedSize() {
        return this.key.length + 4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowCacheKey that = (RowCacheKey)o;
        if (this.cfId != that.cfId) {
            return false;
        }
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.cfId;
        result = 31 * result + (this.key != null ? Arrays.hashCode(this.key) : 0);
        return result;
    }

    @Override
    public int compareTo(RowCacheKey otherKey) {
        return this.cfId < otherKey.cfId ? -1 : (this.cfId == otherKey.cfId ? FBUtilities.compareUnsigned(this.key, otherKey.key, 0, 0, this.key.length, otherKey.key.length) : 1);
    }

    public String toString() {
        return String.format("RowCacheKey(cfId:%d, key:%s)", this.cfId, this.key);
    }
}

