/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TypeParser;

public class ReversedType<T>
extends AbstractType<T> {
    private static final Map<AbstractType<?>, ReversedType> instances = new HashMap();
    final AbstractType<T> baseType;

    public static <T> ReversedType<T> getInstance(TypeParser parser) throws ConfigurationException {
        List<AbstractType<?>> types = parser.getTypeParameters();
        if (types.size() != 1) {
            throw new ConfigurationException("ReversedType takes exactly one argument, " + types.size() + " given");
        }
        return ReversedType.getInstance(types.get(0));
    }

    public static synchronized <T> ReversedType<T> getInstance(AbstractType<T> baseType) {
        ReversedType<T> type = instances.get(baseType);
        if (type == null) {
            type = new ReversedType<T>(baseType);
            instances.put(baseType, type);
        }
        return type;
    }

    private ReversedType(AbstractType<T> baseType) {
        this.baseType = baseType;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return this.baseType.compare(o2, o1);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return this.baseType.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return this.baseType.fromString(source);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        this.baseType.validate(bytes);
    }

    @Override
    public T compose(ByteBuffer bytes) {
        return this.baseType.compose(bytes);
    }

    @Override
    public ByteBuffer decompose(T value) {
        return this.baseType.decompose(value);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.baseType + ")";
    }
}

