/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.IStreamCallback;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamOutSession;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;

public class SSTableLoader {
    private final File directory;
    private final String keyspace;
    private final Client client;
    private final OutputHandler outputHandler;

    public SSTableLoader(File directory, Client client, OutputHandler outputHandler) {
        this.directory = directory;
        this.keyspace = directory.getParentFile().getName();
        this.client = client;
        this.outputHandler = outputHandler;
    }

    protected Collection<SSTableReader> openSSTables() {
        final LinkedList<SSTableReader> sstables = new LinkedList<SSTableReader>();
        this.directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Descriptor desc;
                Pair<Descriptor, Component> p = SSTable.tryComponentFromFilename(dir, name);
                Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
                if (p == null || !((Component)p.right).equals(Component.DATA) || desc.temporary) {
                    return false;
                }
                if (!new File(desc.filenameFor(Component.PRIMARY_INDEX)).exists()) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s because index is missing", name));
                    return false;
                }
                if (!SSTableLoader.this.client.validateColumnFamily(SSTableLoader.this.keyspace, desc.cfname)) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s: column family %s.%s doesn't exist", name, SSTableLoader.this.keyspace, desc.cfname));
                    return false;
                }
                HashSet<Component> components = new HashSet<Component>();
                components.add(Component.DATA);
                components.add(Component.PRIMARY_INDEX);
                if (new File(desc.filenameFor(Component.COMPRESSION_INFO)).exists()) {
                    components.add(Component.COMPRESSION_INFO);
                }
                try {
                    sstables.add(SSTableReader.open(desc, components, null, SSTableLoader.this.client.getPartitioner()));
                }
                catch (IOException e) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s, error opening it: %s", name, e.getMessage()));
                }
                return false;
            }
        });
        return sstables;
    }

    public LoaderFuture stream() throws IOException {
        return this.stream(Collections.<InetAddress>emptySet());
    }

    public LoaderFuture stream(Set<InetAddress> toIgnore) throws IOException {
        this.client.init(this.keyspace);
        Collection<SSTableReader> sstables = this.openSSTables();
        if (sstables.isEmpty()) {
            this.outputHandler.output("No sstables to stream");
            return new LoaderFuture(0);
        }
        Map<InetAddress, Collection<Range<Token>>> endpointToRanges = this.client.getEndpointToRangesMap();
        this.outputHandler.output(String.format("Streaming revelant part of %sto %s", this.names(sstables), endpointToRanges.keySet()));
        LoaderFuture future = new LoaderFuture(endpointToRanges.size());
        for (Map.Entry<InetAddress, Collection<Range<Token>>> entry : endpointToRanges.entrySet()) {
            InetAddress remote = entry.getKey();
            if (toIgnore.contains(remote)) {
                future.latch.countDown();
                continue;
            }
            Collection<Range<Token>> ranges = entry.getValue();
            StreamOutSession session = StreamOutSession.create(this.keyspace, remote, new CountDownCallback(future, remote));
            SSTableReader.acquireReferences(sstables);
            StreamOut.transferSSTables(session, sstables, ranges, OperationType.BULK_LOAD);
            future.setPendings(remote, session.getFiles());
        }
        return future;
    }

    private String names(Collection<SSTableReader> sstables) {
        StringBuilder builder = new StringBuilder();
        for (SSTableReader sstable : sstables) {
            builder.append(sstable.descriptor.filenameFor(Component.DATA)).append(" ");
        }
        return builder.toString();
    }

    static {
        Config.setLoadYaml(false);
    }

    public static abstract class Client {
        private final Map<InetAddress, Collection<Range<Token>>> endpointToRanges = new HashMap<InetAddress, Collection<Range<Token>>>();
        private IPartitioner partitioner;

        public abstract void init(String var1);

        public void stop() {
        }

        public abstract boolean validateColumnFamily(String var1, String var2);

        public Map<InetAddress, Collection<Range<Token>>> getEndpointToRangesMap() {
            return this.endpointToRanges;
        }

        protected void setPartitioner(String partclass) throws ConfigurationException {
            this.setPartitioner(FBUtilities.newPartitioner(partclass));
        }

        protected void setPartitioner(IPartitioner partitioner) throws ConfigurationException {
            this.partitioner = partitioner;
            DatabaseDescriptor.setPartitioner(partitioner);
        }

        public IPartitioner getPartitioner() {
            return this.partitioner;
        }

        protected void addRangeForEndpoint(Range<Token> range, InetAddress endpoint) {
            Collection<Range<Token>> ranges = this.endpointToRanges.get(endpoint);
            if (ranges == null) {
                ranges = new HashSet<Range<Token>>();
                this.endpointToRanges.put(endpoint, ranges);
            }
            ranges.add(range);
        }
    }

    private class CountDownCallback
    implements IStreamCallback {
        private final InetAddress endpoint;
        private final LoaderFuture future;

        CountDownCallback(LoaderFuture future, InetAddress endpoint) {
            this.future = future;
            this.endpoint = endpoint;
        }

        @Override
        public void onSuccess() {
            this.future.latch.countDown();
            SSTableLoader.this.outputHandler.debug(String.format("Streaming session to %s completed (waiting on %d outstanding sessions)", this.endpoint, this.future.latch.getCount()));
            if (this.future.latch.getCount() == 0L) {
                SSTableLoader.this.client.stop();
            }
        }

        @Override
        public void onFailure() {
            SSTableLoader.this.outputHandler.output(String.format("Streaming session to %s failed", this.endpoint));
            this.future.setFailed(this.endpoint);
            this.future.latch.countDown();
            SSTableLoader.this.client.stop();
        }
    }

    public static class LoaderFuture
    implements Future<Void> {
        final CountDownLatch latch;
        final Map<InetAddress, Collection<PendingFile>> pendingFiles;
        private List<InetAddress> failedHosts = new ArrayList<InetAddress>();

        private LoaderFuture(int request) {
            this.latch = new CountDownLatch(request);
            this.pendingFiles = new HashMap<InetAddress, Collection<PendingFile>>();
        }

        private void setPendings(InetAddress remote, Collection<PendingFile> files) {
            this.pendingFiles.put(remote, new ArrayList<PendingFile>(files));
        }

        private void setFailed(InetAddress addr) {
            this.failedHosts.add(addr);
        }

        public List<InetAddress> getFailedHosts() {
            return this.failedHosts;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("Cancellation is not yet supported");
        }

        @Override
        public Void get() throws InterruptedException {
            this.latch.await();
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (this.latch.await(timeout, unit)) {
                return null;
            }
            throw new TimeoutException();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        public boolean hadFailures() {
            return this.failedHosts.size() > 0;
        }

        public Map<InetAddress, Collection<PendingFile>> getPendingFiles() {
            return this.pendingFiles;
        }
    }
}

