/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundTcpConnectionPool;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundTcpConnection
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(OutboundTcpConnection.class);
    private static final Message CLOSE_SENTINEL = new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.INTERNAL_RESPONSE, ArrayUtils.EMPTY_BYTE_ARRAY, 5);
    private volatile boolean isStopped = false;
    private static final int OPEN_RETRY_DELAY = 100;
    private volatile BlockingQueue<Entry> backlog = new LinkedBlockingQueue<Entry>();
    private volatile BlockingQueue<Entry> active = new LinkedBlockingQueue<Entry>();
    private final OutboundTcpConnectionPool poolReference;
    private DataOutputStream out;
    private Socket socket;
    private volatile long completed;
    private final AtomicLong dropped = new AtomicLong();

    public OutboundTcpConnection(OutboundTcpConnectionPool pool) {
        super("WRITE-" + pool.endPoint());
        this.poolReference = pool;
    }

    public void enqueue(Message message, String id) {
        this.expireMessages();
        try {
            this.backlog.put(new Entry(message, id));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    void closeSocket(boolean destroyThread) {
        this.active.clear();
        this.backlog.clear();
        this.isStopped = destroyThread;
        this.enqueue(CLOSE_SENTINEL, null);
    }

    void softCloseSocket() {
        this.enqueue(CLOSE_SENTINEL, null);
    }

    @Override
    public void run() {
        while (true) {
            Entry entry;
            if ((entry = (Entry)this.active.poll()) == null) {
                try {
                    entry = this.backlog.take();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                BlockingQueue<Entry> tmp = this.backlog;
                this.backlog = this.active;
                this.active = tmp;
            }
            Message m = entry.message;
            String id = entry.id;
            if (m == CLOSE_SENTINEL) {
                this.disconnect();
                if (!this.isStopped) continue;
                break;
            }
            if (entry.timestamp < System.currentTimeMillis() - DatabaseDescriptor.getRpcTimeout()) {
                this.dropped.incrementAndGet();
                continue;
            }
            if (this.socket != null || this.connect()) {
                this.writeConnected(entry, id);
                continue;
            }
            this.active.clear();
        }
    }

    public int getPendingMessages() {
        return this.active.size() + this.backlog.size();
    }

    public long getCompletedMesssages() {
        return this.completed;
    }

    public long getDroppedMessages() {
        return this.dropped.get();
    }

    private void writeConnected(Entry entry, String id) {
        block7: {
            Message message = entry.message;
            try {
                OutboundTcpConnection.write(message, id, this.out);
                ++this.completed;
                if (this.active.peek() == null) {
                    this.out.flush();
                }
            }
            catch (Exception e) {
                this.disconnect();
                if (e instanceof IOException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("error writing to " + this.poolReference.endPoint(), (Throwable)e);
                    }
                    if (!(e instanceof SocketException) || !entry.shouldRetry()) break block7;
                    try {
                        this.backlog.put(new RetriedEntry(entry));
                    }
                    catch (InterruptedException e1) {
                        throw new AssertionError((Object)e1);
                    }
                }
                logger.error("error writing to " + this.poolReference.endPoint(), (Throwable)e);
            }
        }
    }

    public static void write(Message message, String id, DataOutputStream out) throws IOException {
        int header = 0;
        header |= MessagingService.serializerType_.ordinal();
        out.writeInt(-900387334);
        out.writeInt(header |= message.getVersion() << 8);
        byte[] bytes = message.getMessageBody();
        int total = OutboundTcpConnection.messageLength(message.header_, id, bytes);
        out.writeInt(total);
        out.writeUTF(id);
        Header.serializer().serialize(message.header_, out, message.getVersion());
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static int messageLength(Header header, String id, byte[] bytes) {
        return 2 + FBUtilities.encodedUTF8Length(id) + header.serializedSize() + 4 + bytes.length;
    }

    private void disconnect() {
        if (this.socket != null) {
            block3: {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("exception closing connection to " + this.poolReference.endPoint(), (Throwable)e);
                }
            }
            this.out = null;
            this.socket = null;
        }
    }

    private boolean connect() {
        if (logger.isDebugEnabled()) {
            logger.debug("attempting to connect to " + this.poolReference.endPoint());
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + DatabaseDescriptor.getRpcTimeout()) {
            try {
                this.socket = this.poolReference.newSocket();
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
                this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 4096));
                return true;
            }
            catch (IOException e) {
                this.socket = null;
                if (logger.isTraceEnabled()) {
                    logger.trace("unable to connect to " + this.poolReference.endPoint(), (Throwable)e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    throw new AssertionError((Object)e1);
                }
            }
        }
        return false;
    }

    private void expireMessages() {
        Entry entry;
        while ((entry = (Entry)this.backlog.peek()) != null && entry.timestamp < System.currentTimeMillis() - DatabaseDescriptor.getRpcTimeout()) {
            Entry entry2 = (Entry)this.backlog.poll();
            if (entry2 != entry) {
                if (entry2 == null) break;
                this.active.add(entry2);
                break;
            }
            this.dropped.incrementAndGet();
        }
    }

    private static class RetriedEntry
    extends Entry {
        RetriedEntry(Entry e) {
            super(e.message, e.id);
        }

        @Override
        boolean shouldRetry() {
            return false;
        }
    }

    private static class Entry {
        final Message message;
        final String id;
        final long timestamp;

        Entry(Message message, String id) {
            this.message = message;
            this.id = id;
            this.timestamp = System.currentTimeMillis();
        }

        boolean shouldRetry() {
            return !MessagingService.DROPPABLE_VERBS.contains((Object)this.message.getVerb());
        }
    }
}

