/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;

public abstract class AbstractCompositeType
extends AbstractType<ByteBuffer> {
    protected static int getShortLength(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    protected static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }

    protected static ByteBuffer getBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    protected static ByteBuffer getWithShortLength(ByteBuffer bb) {
        int length = AbstractCompositeType.getShortLength(bb);
        return AbstractCompositeType.getBytes(bb, length);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (null == o1) {
            return null == o2 ? 0 : -1;
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int i = 0;
        while (bb1.remaining() > 0 && bb2.remaining() > 0) {
            ByteBuffer value2;
            ByteBuffer value1;
            AbstractType<?> comparator = this.getNextComparator(i, bb1, bb2);
            int cmp = comparator.compare(value1 = AbstractCompositeType.getWithShortLength(bb1), value2 = AbstractCompositeType.getWithShortLength(bb2));
            if (cmp != 0) {
                return cmp;
            }
            byte b1 = bb1.get();
            byte b2 = bb2.get();
            if (b1 < 0) {
                if (b2 >= 0) {
                    return -1;
                }
            } else if (b1 > 0) {
                if (b2 <= 0) {
                    return 1;
                }
            } else if (b2 != 0) {
                return -b2;
            }
            ++i;
        }
        if (bb1.remaining() == 0) {
            return bb2.remaining() == 0 ? 0 : -1;
        }
        return 1;
    }

    public ByteBuffer[] split(ByteBuffer name) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        ByteBuffer bb = name.duplicate();
        int i = 0;
        while (bb.remaining() > 0) {
            this.getNextComparator(i++, bb);
            l.add(AbstractCompositeType.getWithShortLength(bb));
            bb.get();
        }
        return l.toArray(new ByteBuffer[l.size()]);
    }

    public List<CompositeComponent> deconstruct(ByteBuffer bytes) {
        ArrayList<CompositeComponent> list = new ArrayList<CompositeComponent>();
        ByteBuffer bb = bytes.duplicate();
        int i = 0;
        while (bb.remaining() > 0) {
            AbstractType<?> comparator = this.getNextComparator(i, bb);
            ByteBuffer value = AbstractCompositeType.getWithShortLength(bb);
            list.add(new CompositeComponent(comparator, value));
            byte b = bb.get();
            ++i;
        }
        return list;
    }

    static String escape(String input) {
        if (input.isEmpty()) {
            return input;
        }
        String res = input.replaceAll(":", "\\\\:");
        char last = res.charAt(res.length() - 1);
        return last == '\\' || last == '!' ? res + '!' : res;
    }

    static String unescape(String input) {
        if (input.isEmpty()) {
            return input;
        }
        String res = input.replaceAll("\\\\:", ":");
        char last = res.charAt(res.length() - 1);
        return last == '!' ? res.substring(0, res.length() - 1) : res;
    }

    static List<String> split(String input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        int prev = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ':' || i > 0 && input.charAt(i - 1) == '\\') continue;
            res.add(input.substring(prev, i));
            prev = i + 1;
        }
        res.add(input.substring(prev, input.length()));
        return res;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        StringBuilder sb = new StringBuilder();
        ByteBuffer bb = bytes.duplicate();
        int i = 0;
        while (bb.remaining() > 0) {
            if (bb.remaining() != bytes.remaining()) {
                sb.append(":");
            }
            AbstractType<?> comparator = this.getAndAppendNextComparator(i, bb, sb);
            ByteBuffer value = AbstractCompositeType.getWithShortLength(bb);
            sb.append(AbstractCompositeType.escape(comparator.getString(value)));
            byte b = bb.get();
            if (b != 0) {
                sb.append(":!");
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public ByteBuffer fromString(String source) {
        List<String> parts = AbstractCompositeType.split(source);
        ArrayList<ByteBuffer> components = new ArrayList<ByteBuffer>(parts.size());
        ArrayList<ParsedComparator> comparators = new ArrayList<ParsedComparator>(parts.size());
        int totalLength = 0;
        int i = 0;
        boolean lastByteIsOne = false;
        for (String part : parts) {
            if (part.equals("!")) {
                lastByteIsOne = true;
                break;
            }
            ParsedComparator p = this.parseNextComparator(i, part);
            AbstractType<?> type = p.getAbstractType();
            part = p.getRemainingPart();
            ByteBuffer component = type.fromString(AbstractCompositeType.unescape(part));
            totalLength += p.getComparatorSerializedSize() + 2 + component.remaining() + 1;
            components.add(component);
            comparators.add(p);
            ++i;
        }
        ByteBuffer bb = ByteBuffer.allocate(totalLength);
        i = 0;
        for (ByteBuffer component : components) {
            ((ParsedComparator)comparators.get(i)).serializeComparator(bb);
            AbstractCompositeType.putShortLength(bb, component.remaining());
            bb.put(component);
            bb.put((byte)0);
            ++i;
        }
        if (lastByteIsOne) {
            bb.put(bb.limit() - 1, (byte)1);
        }
        bb.rewind();
        return bb;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        ByteBuffer bb = bytes.duplicate();
        int i = 0;
        while (bb.remaining() > 0) {
            AbstractType<?> comparator = this.validateNextComparator(i, bb);
            if (bb.remaining() < 2) {
                throw new MarshalException("Not enough bytes to read value size of component " + i);
            }
            int length = AbstractCompositeType.getShortLength(bb);
            if (bb.remaining() < length) {
                throw new MarshalException("Not enough bytes to read value of component " + i);
            }
            ByteBuffer value = AbstractCompositeType.getBytes(bb, length);
            comparator.validate(value);
            if (bb.remaining() == 0) {
                throw new MarshalException("Not enough bytes to read the end-of-component byte of component" + i);
            }
            byte b = bb.get();
            if (b != 0 && bb.remaining() != 0) {
                throw new MarshalException("Invalid bytes remaining after an end-of-component at component" + i);
            }
            ++i;
        }
    }

    @Override
    public ByteBuffer compose(ByteBuffer bytes) {
        return bytes;
    }

    @Override
    public ByteBuffer decompose(ByteBuffer value) {
        return value;
    }

    protected abstract AbstractType<?> getNextComparator(int var1, ByteBuffer var2);

    protected abstract AbstractType<?> getNextComparator(int var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract AbstractType<?> getAndAppendNextComparator(int var1, ByteBuffer var2, StringBuilder var3);

    protected abstract ParsedComparator parseNextComparator(int var1, String var2);

    protected abstract AbstractType<?> validateNextComparator(int var1, ByteBuffer var2) throws MarshalException;

    protected static interface ParsedComparator {
        public AbstractType<?> getAbstractType();

        public String getRemainingPart();

        public int getComparatorSerializedSize();

        public void serializeComparator(ByteBuffer var1);
    }

    public static class CompositeComponent {
        public AbstractType comparator;
        public ByteBuffer value;

        public CompositeComponent(AbstractType comparator, ByteBuffer value) {
            this.comparator = comparator;
            this.value = value;
        }
    }
}

