/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.net.InetAddress;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipShutdownVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(GossipShutdownVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        InetAddress from = message.getFrom();
        if (!Gossiper.instance.isEnabled()) {
            logger.debug("Ignoring shutdown message from {} because gossip is disabled", (Object)from);
            return;
        }
        FailureDetector.instance.forceConviction(from);
    }
}

