/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;

public class ExcludingBounds<T extends RingPosition>
extends AbstractBounds<T> {
    public ExcludingBounds(T left, T right) {
        this(left, right, StorageService.getPartitioner());
    }

    ExcludingBounds(T left, T right, IPartitioner partitioner) {
        super(left, right, partitioner);
        assert (left.compareTo(right) < 0 || right.isMinimum(partitioner)) : "(" + left + "," + right + ")";
    }

    @Override
    public boolean contains(T position) {
        return Range.contains(this.left, this.right, position) && !this.right.equals(position);
    }

    @Override
    public Pair<AbstractBounds<T>, AbstractBounds<T>> split(T position) {
        assert (this.contains(position) || this.left.equals(position));
        if (this.left.equals(position)) {
            return null;
        }
        Range<RingPosition> lb = new Range<RingPosition>(this.left, (RingPosition)position, this.partitioner);
        ExcludingBounds<RingPosition> rb = new ExcludingBounds<RingPosition>((RingPosition)position, this.right, this.partitioner);
        return new Pair<AbstractBounds<T>, AbstractBounds<T>>(lb, rb);
    }

    @Override
    public List<? extends AbstractBounds<T>> unwrap() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExcludingBounds)) {
            return false;
        }
        ExcludingBounds rhs = (ExcludingBounds)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "(" + this.left + "," + this.right + ")";
    }

    private static ExcludingBounds<RowPosition> makeRowBounds(Token left, Token right, IPartitioner partitioner) {
        return new ExcludingBounds<RowPosition>(left.maxKeyBound(partitioner), right.minKeyBound(partitioner), partitioner);
    }

    @Override
    public AbstractBounds<RowPosition> toRowBounds() {
        return this.left instanceof Token ? ExcludingBounds.makeRowBounds((Token)this.left, (Token)this.right, this.partitioner) : this;
    }

    @Override
    public AbstractBounds<Token> toTokenBounds() {
        return this.left instanceof RowPosition ? new ExcludingBounds<Token>(((RowPosition)this.left).getToken(), ((RowPosition)this.right).getToken(), this.partitioner) : this;
    }
}

