/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.IColumnIteratorFactory;

public class LazyColumnIterator
extends AbstractIterator<IColumn>
implements IColumnIterator {
    private final DecoratedKey key;
    private final IColumnIteratorFactory subIteratorFactory;
    private IColumnIterator subIterator;

    public LazyColumnIterator(DecoratedKey key, IColumnIteratorFactory subIteratorFactory) {
        this.key = key;
        this.subIteratorFactory = subIteratorFactory;
    }

    private IColumnIterator getSubIterator() {
        if (this.subIterator == null) {
            this.subIterator = this.subIteratorFactory.create();
        }
        return this.subIterator;
    }

    protected IColumn computeNext() {
        this.getSubIterator();
        return this.subIterator.hasNext() ? (IColumn)this.subIterator.next() : (IColumn)this.endOfData();
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.getSubIterator().getColumnFamily();
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public void close() throws IOException {
        if (this.subIterator != null) {
            this.subIterator.close();
        }
    }
}

