/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class Memory {
    private static final Unsafe unsafe;
    protected long peer;
    private final long size;

    protected Memory(long bytes) {
        this.size = bytes;
        this.peer = unsafe.allocateMemory(this.size);
    }

    public static Memory allocate(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException();
        }
        return new Memory(bytes);
    }

    public void setByte(long offset, byte b) {
        this.checkPosition(offset);
        unsafe.putByte(this.peer + offset, b);
    }

    public void setBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || bufferOffset + count > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkPosition(memoryOffset);
        long end = memoryOffset + (long)count;
        this.checkPosition(end - 1L);
        while (memoryOffset < end) {
            unsafe.putByte(this.peer + memoryOffset++, buffer[bufferOffset++]);
        }
    }

    public byte getByte(long offset) {
        this.checkPosition(offset);
        return unsafe.getByte(this.peer + offset);
    }

    public void getBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || count > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkPosition(memoryOffset);
        long end = memoryOffset + (long)count;
        this.checkPosition(end - 1L);
        while (memoryOffset < end) {
            buffer[bufferOffset++] = unsafe.getByte(this.peer + memoryOffset++);
        }
    }

    private void checkPosition(long offset) {
        if (this.peer == 0L) {
            throw new IllegalStateException("Memory was freed");
        }
        if (offset < 0L || offset >= this.size) {
            throw new IndexOutOfBoundsException("Illegal offset: " + offset + ", size: " + this.size);
        }
    }

    public void free() {
        assert (this.peer != 0L);
        unsafe.freeMemory(this.peer);
        this.peer = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.peer != 0L) {
                this.free();
            }
        }
        finally {
            super.finalize();
        }
    }

    public long size() {
        return this.size;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

