/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.Pair;

public class SSTableBoundedScanner
extends SSTableScanner {
    private final Iterator<Pair<Long, Long>> rangeIterator;
    private Pair<Long, Long> currentRange;

    SSTableBoundedScanner(SSTableReader sstable, boolean skipCache, Range<Token> range) {
        super(sstable, skipCache);
        this.rangeIterator = sstable.getPositionsForRanges(Collections.singletonList(range)).iterator();
        if (this.rangeIterator.hasNext()) {
            this.currentRange = this.rangeIterator.next();
            try {
                this.file.seek((Long)this.currentRange.left);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.exhausted = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IColumnIterator[0]).iterator() : new BoundedKeyScanningIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public IColumnIterator next() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IColumnIterator[0]).iterator() : new BoundedKeyScanningIterator();
        }
        return (IColumnIterator)this.iterator.next();
    }

    protected class BoundedKeyScanningIterator
    extends SSTableScanner.KeyScanningIterator {
        protected BoundedKeyScanningIterator() {
            super(SSTableBoundedScanner.this);
        }

        @Override
        public boolean hasNext() {
            if (!super.hasNext()) {
                return false;
            }
            if (this.finishedAt < (Long)((SSTableBoundedScanner)SSTableBoundedScanner.this).currentRange.right) {
                return true;
            }
            if (SSTableBoundedScanner.this.rangeIterator.hasNext()) {
                SSTableBoundedScanner.this.currentRange = (Pair)SSTableBoundedScanner.this.rangeIterator.next();
                this.finishedAt = (Long)((SSTableBoundedScanner)SSTableBoundedScanner.this).currentRange.left;
                return true;
            }
            return false;
        }
    }
}

