/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RetriedSliceFromReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.service.RepairCallback;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceFromReadCommand
extends ReadCommand {
    static final Logger logger = LoggerFactory.getLogger(SliceFromReadCommand.class);
    public final ByteBuffer start;
    public final ByteBuffer finish;
    public final boolean reversed;
    public final int count;

    public SliceFromReadCommand(String table, ByteBuffer key, ColumnParent column_parent, ByteBuffer start, ByteBuffer finish, boolean reversed, int count) {
        this(table, key, new QueryPath(column_parent), start, finish, reversed, count);
    }

    public SliceFromReadCommand(String table, ByteBuffer key, QueryPath path, ByteBuffer start, ByteBuffer finish, boolean reversed, int count) {
        super(table, key, path, (byte)2);
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
    }

    @Override
    public ReadCommand copy() {
        SliceFromReadCommand readCommand = new SliceFromReadCommand(this.table, this.key, this.queryPath, this.start, this.finish, this.reversed, this.count);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public Row getRow(Table table) throws IOException {
        DecoratedKey dk = StorageService.getPartitioner().decorateKey(this.key);
        return table.getRow(QueryFilter.getSliceFilter(dk, this.queryPath, this.start, this.finish, this.reversed, this.count));
    }

    @Override
    public ReadCommand maybeGenerateRetryCommand(RepairCallback handler, Row row) {
        int liveColumnsInRow;
        int maxLiveColumns = handler.getMaxLiveColumns();
        int n = liveColumnsInRow = row != null ? row.cf.getLiveColumnCount() : 0;
        assert (maxLiveColumns <= this.count);
        if (maxLiveColumns == this.count && liveColumnsInRow < this.getOriginalRequestedCount()) {
            int retryCount = liveColumnsInRow == 0 ? this.count + 1 : this.count * this.count / liveColumnsInRow + 1;
            return new RetriedSliceFromReadCommand(this.table, this.key, this.queryPath, this.start, this.finish, this.reversed, this.getOriginalRequestedCount(), retryCount);
        }
        return null;
    }

    @Override
    public void maybeTrim(Row row) {
        if (row == null || row.cf == null) {
            return;
        }
        int liveColumnsInRow = row.cf.getLiveColumnCount();
        if (liveColumnsInRow > this.getOriginalRequestedCount()) {
            int columnsToTrim = liveColumnsInRow - this.getOriginalRequestedCount();
            logger.debug("trimming {} live columns to the originally requested {}", (Object)row.cf.getLiveColumnCount(), (Object)this.getOriginalRequestedCount());
            Collection<IColumn> columns = this.reversed ? row.cf.getSortedColumns() : row.cf.getReverseSortedColumns();
            HashSet<ByteBuffer> toRemove = new HashSet<ByteBuffer>();
            Iterator<IColumn> columnIterator = columns.iterator();
            while (columnIterator.hasNext() && toRemove.size() < columnsToTrim) {
                IColumn column = columnIterator.next();
                if (!column.isLive()) continue;
                toRemove.add(column.name());
            }
            for (ByteBuffer columnName : toRemove) {
                row.cf.remove(columnName);
            }
        }
    }

    protected int getOriginalRequestedCount() {
        return this.count;
    }

    public String toString() {
        return "SliceFromReadCommand(table='" + this.table + '\'' + ", key='" + ByteBufferUtil.bytesToHex(this.key) + '\'' + ", column_parent='" + this.queryPath + '\'' + ", start='" + this.getComparator().getString(this.start) + '\'' + ", finish='" + this.getComparator().getString(this.finish) + '\'' + ", reversed=" + this.reversed + ", count=" + this.count + ')';
    }
}

