/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMutationVerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(RowMutationVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        try {
            byte[] forwardBytes;
            RowMutation rm = RowMutation.fromBytes(message.getMessageBody(), message.getVersion());
            if (logger_.isDebugEnabled()) {
                logger_.debug("Applying " + rm);
            }
            if ((forwardBytes = message.getHeader("FORWARD")) != null && message.getVersion() >= 4) {
                this.forwardToLocalNodes(message, forwardBytes);
            }
            rm.apply();
            WriteResponse response = new WriteResponse(rm.getTable(), rm.key(), true);
            Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
            if (logger_.isDebugEnabled()) {
                logger_.debug(rm + " applied.  Sending response to " + id + "@" + message.getFrom());
            }
            MessagingService.instance().sendReply(responseMessage, id, message.getFrom());
        }
        catch (IOException e) {
            logger_.error("Error in row mutation", (Throwable)e);
        }
    }

    private void forwardToLocalNodes(Message message, byte[] forwardBytes) throws IOException {
        DataInputStream dis = new DataInputStream(new FastByteArrayInputStream(forwardBytes));
        int size = dis.readInt();
        Message messageCopy = message.withHeaderRemoved("FORWARD");
        for (int i = 0; i < size; ++i) {
            InetAddress address = CompactEndpointSerializationHelper.deserialize(dis);
            String id = dis.readUTF();
            if (logger_.isDebugEnabled()) {
                logger_.debug("Forwarding message to " + address + " with= ID: " + id);
            }
            MessagingService.instance().sendOneWay(messageCopy, id, address);
        }
    }
}

