/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.UnavailableException;

public class TruncateStatement
extends CFStatement
implements CQLStatement {
    public TruncateStatement(CFName name) {
        super(name);
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.WRITE);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
    }

    @Override
    public CqlResult execute(ClientState state, List<ByteBuffer> variables) throws InvalidRequestException, UnavailableException {
        try {
            StorageProxy.truncateBlocking(this.keyspace(), this.columnFamily());
        }
        catch (TimeoutException e) {
            throw (UnavailableException)new UnavailableException().initCause((Throwable)e);
        }
        catch (IOException e) {
            throw (UnavailableException)new UnavailableException().initCause((Throwable)e);
        }
        return null;
    }
}

