/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final CharSequence index;

    public DropIndexStatement(String indexName) {
        super(new CFName());
        this.index = indexName;
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData cfm;
        CfDef cfDef = null;
        KSMetaData ksm = Schema.instance.getTableDefinition(this.keyspace());
        Iterator<CFMetaData> i$ = ksm.cfMetaData().values().iterator();
        while (i$.hasNext() && (cfDef = this.getUpdatedCFDef((cfm = i$.next()).toThrift())) == null) {
        }
        if (cfDef == null) {
            throw new InvalidRequestException("Index '" + this.index + "' could not be found in any of the column families of keyspace '" + this.keyspace() + "'");
        }
        MigrationManager.announceColumnFamilyUpdate(CFMetaData.fromThrift(cfDef));
    }

    private CfDef getUpdatedCFDef(CfDef cfDef) throws InvalidRequestException {
        for (ColumnDef column : cfDef.column_metadata) {
            if (column.index_type == null || column.index_name == null || !column.index_name.equals(this.index)) continue;
            column.index_name = null;
            column.index_type = null;
            return cfDef;
        }
        return null;
    }
}

