/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.CqlRow;

public class UntypedResultSet
implements Iterable<Row> {
    private final List<CqlRow> cqlRows;

    public UntypedResultSet(List<CqlRow> cqlRows) {
        this.cqlRows = cqlRows;
    }

    public Row one() {
        if (this.cqlRows.size() != 1) {
            throw new IllegalStateException("One row required, " + this.cqlRows.size() + " found");
        }
        return new Row(this.cqlRows.get(0));
    }

    @Override
    public Iterator<Row> iterator() {
        return new AbstractIterator<Row>(){
            Iterator<CqlRow> iter;
            {
                this.iter = UntypedResultSet.this.cqlRows.iterator();
            }

            protected Row computeNext() {
                if (!this.iter.hasNext()) {
                    return (Row)this.endOfData();
                }
                return new Row(this.iter.next());
            }
        };
    }

    public static class Row {
        Map<String, ByteBuffer> data = new HashMap<String, ByteBuffer>();

        public Row(CqlRow cqlRow) {
            for (Column column : cqlRow.columns) {
                this.data.put(UTF8Type.instance.compose(column.name), column.value);
            }
        }

        public boolean has(String column) {
            return this.data.get(column) != null;
        }

        public String getString(String column) {
            return UTF8Type.instance.compose(this.data.get(column));
        }

        public boolean getBoolean(String column) {
            return BooleanType.instance.compose(this.data.get(column));
        }

        public int getInt(String column) {
            return Int32Type.instance.compose(this.data.get(column));
        }

        public double getDouble(String column) {
            return DoubleType.instance.compose(this.data.get(column));
        }

        public ByteBuffer getBytes(String column) {
            return this.data.get(column);
        }
    }
}

