/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.InvalidRequestException;

public class CreateKeyspaceStatement {
    private final String name;
    private final Map<String, String> attrs;
    private String strategyClass;
    private Map<String, String> strategyOptions = new HashMap<String, String>();

    public CreateKeyspaceStatement(String name, Map<String, String> attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    public void validate() throws InvalidRequestException {
        if (!this.name.matches("\\w+")) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid keyspace name", this.name));
        }
        if (this.name.length() > 32) {
            throw new InvalidRequestException(String.format("Keyspace names shouldn't be more than 32 character long (got \"%s\")", this.name));
        }
        if (!this.attrs.containsKey("strategy_class")) {
            throw new InvalidRequestException("missing required argument \"strategy_class\"");
        }
        this.strategyClass = this.attrs.get("strategy_class");
        for (String key : this.attrs.keySet()) {
            if (!key.contains(":") || !key.startsWith("strategy_options")) continue;
            this.strategyOptions.put(key.split(":")[1], this.attrs.get(key));
        }
        try {
            AbstractReplicationStrategy.createReplicationStrategy(this.name, AbstractReplicationStrategy.getClass(this.strategyClass), StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), this.strategyOptions);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getStrategyClass() {
        return this.strategyClass;
    }

    public Map<String, String> getStrategyOptions() {
        return this.strategyOptions;
    }
}

