/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.cache.InstrumentingCacheMBean;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class NodeCmd {
    private static final Pair<String, String> HOST_OPT = new Pair<String, String>("h", "host");
    private static final Pair<String, String> PORT_OPT = new Pair<String, String>("p", "port");
    private static final Pair<String, String> USERNAME_OPT = new Pair<String, String>("u", "username");
    private static final Pair<String, String> PASSWORD_OPT = new Pair<String, String>("pw", "password");
    private static final Pair<String, String> TAG_OPT = new Pair<String, String>("t", "tag");
    private static final Pair<String, String> PRIMARY_RANGE_OPT = new Pair<String, String>("pr", "partitioner-range");
    private static final int DEFAULT_PORT = 7199;
    private static ToolOptions options = null;
    private NodeProbe probe;

    public NodeCmd(NodeProbe probe) {
        this.probe = probe;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        StringBuilder header = new StringBuilder();
        header.append("\nAvailable commands:\n");
        NodeCmd.addCmdHelp(header, "ring", "Print informations on the token ring");
        NodeCmd.addCmdHelp(header, "join", "Join the ring");
        NodeCmd.addCmdHelp(header, "info", "Print node informations (uptime, load, ...)");
        NodeCmd.addCmdHelp(header, "cfstats", "Print statistics on column families");
        NodeCmd.addCmdHelp(header, "version", "Print cassandra version");
        NodeCmd.addCmdHelp(header, "tpstats", "Print usage statistics of thread pools");
        NodeCmd.addCmdHelp(header, "drain", "Drain the node (stop accepting writes and flush all column families)");
        NodeCmd.addCmdHelp(header, "decommission", "Decommission the node");
        NodeCmd.addCmdHelp(header, "compactionstats", "Print statistics on compactions");
        NodeCmd.addCmdHelp(header, "disablegossip", "Disable gossip (effectively marking the node dead)");
        NodeCmd.addCmdHelp(header, "enablegossip", "Reenable gossip");
        NodeCmd.addCmdHelp(header, "disablethrift", "Disable thrift server");
        NodeCmd.addCmdHelp(header, "enablethrift", "Reenable thrift server");
        NodeCmd.addCmdHelp(header, "statusthrift", "Status of thrift server");
        NodeCmd.addCmdHelp(header, "gossipinfo", "Shows the gossip information for the cluster");
        NodeCmd.addCmdHelp(header, "netstats [host]", "Print network information on provided host (connecting node by default)");
        NodeCmd.addCmdHelp(header, "move <new token>", "Move node on the token ring to a new token");
        NodeCmd.addCmdHelp(header, "removetoken status|force|<token>", "Show status of current token removal, force completion of pending removal or remove providen token");
        NodeCmd.addCmdHelp(header, "setcompactionthroughput <value_in_mb>", "Set the MB/s throughput cap for compaction in the system, or 0 to disable throttling.");
        NodeCmd.addCmdHelp(header, "setstreamthroughput <value_in_mb>", "Set the MB/s throughput cap for streaming in the system, or 0 to disable throttling.");
        NodeCmd.addCmdHelp(header, "describering [keyspace]", "Shows the token ranges info of a given keyspace.");
        NodeCmd.addCmdHelp(header, "snapshot [keyspaces...] -t [snapshotName]", "Take a snapshot of the specified keyspaces using optional name snapshotName");
        NodeCmd.addCmdHelp(header, "clearsnapshot [keyspaces...] -t [snapshotName]", "Remove snapshots for the specified keyspaces. Either remove all snapshots or remove the snapshots with the given name.");
        NodeCmd.addCmdHelp(header, "flush [keyspace] [cfnames]", "Flush one or more column family");
        NodeCmd.addCmdHelp(header, "repair [keyspace] [cfnames]", "Repair one or more column family (use -pr to repair only the first range returned by the partitioner)");
        NodeCmd.addCmdHelp(header, "cleanup [keyspace] [cfnames]", "Run cleanup on one or more column family");
        NodeCmd.addCmdHelp(header, "compact [keyspace] [cfnames]", "Force a (major) compaction on one or more column family");
        NodeCmd.addCmdHelp(header, "scrub [keyspace] [cfnames]", "Scrub (rebuild sstables for) one or more column family");
        NodeCmd.addCmdHelp(header, "upgradesstables [keyspace] [cfnames]", "Upgrade sstables for one or more column family");
        NodeCmd.addCmdHelp(header, "invalidatekeycache [keyspace] [cfnames]", "Invalidate the key cache of one or more column family");
        NodeCmd.addCmdHelp(header, "invalidaterowcache [keyspace] [cfnames]", "Invalidate the key cache of one or more column family");
        NodeCmd.addCmdHelp(header, "getcompactionthreshold <keyspace> <cfname>", "Print min and max compaction thresholds for a given column family");
        NodeCmd.addCmdHelp(header, "cfhistograms <keyspace> <cfname>", "Print statistic histograms for a given column family");
        NodeCmd.addCmdHelp(header, "refresh <keyspace> <cf-name>", "Load newly placed SSTables to the system without restart.");
        NodeCmd.addCmdHelp(header, "getendpoints <keyspace> <cf> <key>", "Print the end points that owns the key");
        NodeCmd.addCmdHelp(header, "setcachecapacity <keyspace> <cfname> <keycachecapacity> <rowcachecapacity>", "Set the key and row cache capacities of a given column family");
        NodeCmd.addCmdHelp(header, "setcompactionthreshold <keyspace> <cfname> <minthreshold> <maxthreshold>", "Set the min and max compaction thresholds for a given column family");
        String usage = String.format("java %s --host <arg> <command>%n", NodeCmd.class.getName());
        hf.printHelp(usage, "", (Options)options, "");
        System.out.println(header.toString());
    }

    private static void addCmdHelp(StringBuilder sb, String cmd, String description) {
        sb.append("  ").append(cmd);
        if (cmd.length() <= 20) {
            for (int i = cmd.length(); i < 22; ++i) {
                sb.append(" ");
            }
        }
        sb.append(" - ").append(description).append("\n");
    }

    public void printRing(PrintStream outs) {
        Map<Token, String> tokenToEndpoint = this.probe.getTokenToEndpointMap();
        ArrayList<Token> sortedTokens = new ArrayList<Token>(tokenToEndpoint.keySet());
        Collections.sort(sortedTokens);
        List<String> liveNodes = this.probe.getLiveNodes();
        List<String> deadNodes = this.probe.getUnreachableNodes();
        List<String> joiningNodes = this.probe.getJoiningNodes();
        List<String> leavingNodes = this.probe.getLeavingNodes();
        List<String> movingNodes = this.probe.getMovingNodes();
        Map<String, String> loadMap = this.probe.getLoadMap();
        String format = "%-16s%-12s%-12s%-7s%-8s%-16s%-8s%-44s%n";
        outs.printf(format, "Address", "DC", "Rack", "Status", "State", "Load", "Owns", "Token");
        if (sortedTokens.size() > 1) {
            outs.printf(format, "", "", "", "", "", "", "", sortedTokens.get(sortedTokens.size() - 1));
        }
        Map<Token, Float> ownerships = this.probe.getOwnership();
        for (Token token : sortedTokens) {
            String rack;
            String dataCenter;
            String primaryEndpoint = tokenToEndpoint.get(token);
            try {
                dataCenter = this.probe.getEndpointSnitchInfoProxy().getDatacenter(primaryEndpoint);
            }
            catch (UnknownHostException e) {
                dataCenter = "Unknown";
            }
            try {
                rack = this.probe.getEndpointSnitchInfoProxy().getRack(primaryEndpoint);
            }
            catch (UnknownHostException e) {
                rack = "Unknown";
            }
            String status = liveNodes.contains(primaryEndpoint) ? "Up" : (deadNodes.contains(primaryEndpoint) ? "Down" : "?");
            String state = "Normal";
            if (joiningNodes.contains(primaryEndpoint)) {
                state = "Joining";
            } else if (leavingNodes.contains(primaryEndpoint)) {
                state = "Leaving";
            } else if (movingNodes.contains(primaryEndpoint)) {
                state = "Moving";
            }
            String load = loadMap.containsKey(primaryEndpoint) ? loadMap.get(primaryEndpoint) : "?";
            String owns = new DecimalFormat("##0.00%").format(ownerships.get(token));
            outs.printf(format, primaryEndpoint, dataCenter, rack, status, state, load, owns, token);
        }
    }

    public void printThreadPoolStats(PrintStream outs) {
        outs.printf("%-25s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
        Iterator<Map.Entry<String, JMXEnabledThreadPoolExecutorMBean>> threads = this.probe.getThreadPoolMBeanProxies();
        while (threads.hasNext()) {
            Map.Entry<String, JMXEnabledThreadPoolExecutorMBean> thread = threads.next();
            String poolName = thread.getKey();
            JMXEnabledThreadPoolExecutorMBean threadPoolProxy = thread.getValue();
            outs.printf("%-25s%10s%10s%15s%10s%18s%n", poolName, threadPoolProxy.getActiveCount(), threadPoolProxy.getPendingTasks(), threadPoolProxy.getCompletedTasks(), threadPoolProxy.getCurrentlyBlockedTasks(), threadPoolProxy.getTotalBlockedTasks());
        }
        outs.printf("%n%-20s%10s%n", "Message type", "Dropped");
        for (Map.Entry<String, Integer> entry : this.probe.getDroppedMessages().entrySet()) {
            outs.printf("%-20s%10s%n", entry.getKey(), entry.getValue());
        }
    }

    public void printInfo(PrintStream outs) {
        boolean gossipInitialized = this.probe.isInitialized();
        outs.printf("%-17s: %s%n", "Token", this.probe.getToken());
        outs.printf("%-17s: %s%n", "Gossip active", gossipInitialized);
        outs.printf("%-17s: %s%n", "Load", this.probe.getLoadString());
        if (gossipInitialized) {
            outs.printf("%-17s: %s%n", "Generation No", this.probe.getCurrentGenerationNumber());
        } else {
            outs.printf("%-17s: %s%n", "Generation No", 0);
        }
        long secondsUp = this.probe.getUptime() / 1000L;
        outs.printf("%-17s: %d%n", "Uptime (seconds)", secondsUp);
        MemoryUsage heapUsage = this.probe.getHeapMemoryUsage();
        double memUsed = (double)heapUsage.getUsed() / 1048576.0;
        double memMax = (double)heapUsage.getMax() / 1048576.0;
        outs.printf("%-17s: %.2f / %.2f%n", "Heap Memory (MB)", memUsed, memMax);
        outs.printf("%-17s: %s%n", "Data Center", this.probe.getDataCenter());
        outs.printf("%-17s: %s%n", "Rack", this.probe.getRack());
        outs.printf("%-17s: %s%n", "Exceptions", this.probe.getExceptionCount());
    }

    public void printReleaseVersion(PrintStream outs) {
        outs.println("ReleaseVersion: " + this.probe.getReleaseVersion());
    }

    public void printNetworkStats(final InetAddress addr, PrintStream outs) {
        List<String> files;
        Set<InetAddress> hosts;
        outs.printf("Mode: %s%n", this.probe.getOperationMode());
        Set<InetAddress> set = hosts = addr == null ? this.probe.getStreamDestinations() : new HashSet<InetAddress>(){
            {
                this.add(addr);
            }
        };
        if (hosts.size() == 0) {
            outs.println("Not sending any streams.");
        }
        for (InetAddress host : hosts) {
            try {
                files = this.probe.getFilesDestinedFor(host);
                if (files.size() > 0) {
                    outs.printf("Streaming to: %s%n", host);
                    for (String file : files) {
                        outs.printf("   %s%n", file);
                    }
                    continue;
                }
                outs.printf(" Nothing streaming to %s%n", host);
            }
            catch (IOException ex) {
                outs.printf("   Error retrieving file data for %s%n", host);
            }
        }
        Set<InetAddress> set2 = hosts = addr == null ? this.probe.getStreamSources() : new HashSet<InetAddress>(){
            {
                this.add(addr);
            }
        };
        if (hosts.size() == 0) {
            outs.println("Not receiving any streams.");
        }
        for (InetAddress host : hosts) {
            try {
                files = this.probe.getIncomingFiles(host);
                if (files.size() > 0) {
                    outs.printf("Streaming from: %s%n", host);
                    for (String file : files) {
                        outs.printf("   %s%n", file);
                    }
                    continue;
                }
                outs.printf(" Nothing streaming from %s%n", host);
            }
            catch (IOException ex) {
                outs.printf("   Error retrieving file data for %s%n", host);
            }
        }
        MessagingServiceMBean ms = this.probe.msProxy;
        outs.printf("%-25s", "Pool Name");
        outs.printf("%10s", "Active");
        outs.printf("%10s", "Pending");
        outs.printf("%15s%n", "Completed");
        int pending = 0;
        Iterator<Number> i$ = ms.getCommandPendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            pending += n;
        }
        long completed = 0L;
        i$ = ms.getCommandCompletedTasks().values().iterator();
        while (i$.hasNext()) {
            long n = (Long)i$.next();
            completed += n;
        }
        outs.printf("%-25s%10s%10s%15s%n", "Commands", "n/a", pending, completed);
        pending = 0;
        i$ = ms.getResponsePendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            pending += n;
        }
        completed = 0L;
        i$ = ms.getResponseCompletedTasks().values().iterator();
        while (i$.hasNext()) {
            long n = (Long)i$.next();
            completed += n;
        }
        outs.printf("%-25s%10s%10s%15s%n", "Responses", "n/a", pending, completed);
    }

    public void printCompactionStats(PrintStream outs) {
        CompactionManagerMBean cm = this.probe.getCompactionManagerProxy();
        outs.println("pending tasks: " + cm.getPendingTasks());
        if (cm.getCompactions().size() > 0) {
            outs.printf("%25s%16s%16s%16s%16s%10s%n", "compaction type", "keyspace", "column family", "bytes compacted", "bytes total", "progress");
        }
        for (CompactionInfo c : cm.getCompactions()) {
            String percentComplete = c.getTotalBytes() == 0L ? "n/a" : new DecimalFormat("0.00").format((double)c.getBytesComplete() / (double)c.getTotalBytes() * 100.0) + "%";
            outs.printf("%25s%16s%16s%16s%16s%10s%n", new Object[]{c.getTaskType(), c.getKeyspace(), c.getColumnFamily(), c.getBytesComplete(), c.getTotalBytes(), percentComplete});
        }
    }

    public void printColumnFamilyStats(PrintStream outs) {
        ArrayList<ColumnFamilyStoreMBean> columnFamilies;
        HashMap cfstoreMap = new HashMap();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> cfamilies = this.probe.getColumnFamilyStoreMBeanProxies();
        while (cfamilies.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = cfamilies.next();
            String tableName = entry.getKey();
            ColumnFamilyStoreMBean cfsProxy = entry.getValue();
            if (!cfstoreMap.containsKey(tableName)) {
                columnFamilies = new ArrayList<ColumnFamilyStoreMBean>();
                columnFamilies.add(cfsProxy);
                cfstoreMap.put(tableName, columnFamilies);
                continue;
            }
            ((List)cfstoreMap.get(tableName)).add(cfsProxy);
        }
        for (Map.Entry entry : cfstoreMap.entrySet()) {
            String tableName = (String)entry.getKey();
            columnFamilies = (ArrayList<ColumnFamilyStoreMBean>)entry.getValue();
            long tableReadCount = 0L;
            long tableWriteCount = 0L;
            int tablePendingTasks = 0;
            double tableTotalReadTime = 0.0;
            double tableTotalWriteTime = 0.0;
            outs.println("Keyspace: " + tableName);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                long writeCount = cfstore.getWriteCount();
                long readCount = cfstore.getReadCount();
                if (readCount > 0L) {
                    tableReadCount += readCount;
                    tableTotalReadTime += (double)cfstore.getTotalReadLatencyMicros();
                }
                if (writeCount > 0L) {
                    tableWriteCount += writeCount;
                    tableTotalWriteTime += (double)cfstore.getTotalWriteLatencyMicros();
                }
                tablePendingTasks += cfstore.getPendingTasks();
            }
            double tableReadLatency = tableReadCount > 0L ? tableTotalReadTime / (double)tableReadCount / 1000.0 : Double.NaN;
            double tableWriteLatency = tableWriteCount > 0L ? tableTotalWriteTime / (double)tableWriteCount / 1000.0 : Double.NaN;
            outs.println("\tRead Count: " + tableReadCount);
            outs.println("\tRead Latency: " + String.format("%s", tableReadLatency) + " ms.");
            outs.println("\tWrite Count: " + tableWriteCount);
            outs.println("\tWrite Latency: " + String.format("%s", tableWriteLatency) + " ms.");
            outs.println("\tPending Tasks: " + tablePendingTasks);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                outs.println("\t\tColumn Family: " + cfstore.getColumnFamilyName());
                outs.println("\t\tSSTable count: " + cfstore.getLiveSSTableCount());
                outs.println("\t\tSpace used (live): " + cfstore.getLiveDiskSpaceUsed());
                outs.println("\t\tSpace used (total): " + cfstore.getTotalDiskSpaceUsed());
                outs.println("\t\tNumber of Keys (estimate): " + cfstore.estimateKeys());
                outs.println("\t\tMemtable Columns Count: " + cfstore.getMemtableColumnsCount());
                outs.println("\t\tMemtable Data Size: " + cfstore.getMemtableDataSize());
                outs.println("\t\tMemtable Switch Count: " + cfstore.getMemtableSwitchCount());
                outs.println("\t\tRead Count: " + cfstore.getReadCount());
                outs.println("\t\tRead Latency: " + String.format("%01.3f", cfstore.getRecentReadLatencyMicros() / 1000.0) + " ms.");
                outs.println("\t\tWrite Count: " + cfstore.getWriteCount());
                outs.println("\t\tWrite Latency: " + String.format("%01.3f", cfstore.getRecentWriteLatencyMicros() / 1000.0) + " ms.");
                outs.println("\t\tPending Tasks: " + cfstore.getPendingTasks());
                outs.println("\t\tBloom Filter False Postives: " + cfstore.getBloomFilterFalsePositives());
                outs.println("\t\tBloom Filter False Ratio: " + String.format("%01.5f", cfstore.getRecentBloomFilterFalseRatio()));
                outs.println("\t\tBloom Filter Space Used: " + cfstore.getBloomFilterDiskSpaceUsed());
                InstrumentingCacheMBean keyCacheMBean = this.probe.getKeyCacheMBean(tableName, cfstore.getColumnFamilyName());
                if (keyCacheMBean.getCapacity() > 0) {
                    outs.println("\t\tKey cache capacity: " + keyCacheMBean.getCapacity());
                    outs.println("\t\tKey cache size: " + keyCacheMBean.getSize());
                    outs.println("\t\tKey cache hit rate: " + keyCacheMBean.getRecentHitRate());
                } else {
                    outs.println("\t\tKey cache: disabled");
                }
                InstrumentingCacheMBean rowCacheMBean = this.probe.getRowCacheMBean(tableName, cfstore.getColumnFamilyName());
                if (rowCacheMBean.getCapacity() > 0) {
                    outs.println("\t\tRow cache capacity: " + rowCacheMBean.getCapacity());
                    outs.println("\t\tRow cache size: " + rowCacheMBean.getSize());
                    outs.println("\t\tRow cache hit rate: " + rowCacheMBean.getRecentHitRate());
                } else {
                    outs.println("\t\tRow cache: disabled");
                }
                outs.println("\t\tCompacted row minimum size: " + cfstore.getMinRowSize());
                outs.println("\t\tCompacted row maximum size: " + cfstore.getMaxRowSize());
                outs.println("\t\tCompacted row mean size: " + cfstore.getMeanRowSize());
                outs.println("");
            }
            outs.println("----------------");
        }
    }

    public void printRemovalStatus(PrintStream outs) {
        outs.println("RemovalStatus: " + this.probe.getRemovalStatus());
    }

    private void printCfHistograms(String keySpace, String columnFamily, PrintStream output) {
        ColumnFamilyStoreMBean store = this.probe.getCfsProxy(keySpace, columnFamily);
        long[] offsets = new EstimatedHistogram().getBucketOffsets();
        long[] rrlh = store.getRecentReadLatencyHistogramMicros();
        long[] rwlh = store.getRecentWriteLatencyHistogramMicros();
        long[] sprh = store.getRecentSSTablesPerReadHistogram();
        long[] ersh = store.getEstimatedRowSizeHistogram();
        long[] ecch = store.getEstimatedColumnCountHistogram();
        output.println(String.format("%s/%s histograms", keySpace, columnFamily));
        output.println(String.format("%-10s%10s%18s%18s%18s%18s", "Offset", "SSTables", "Write Latency", "Read Latency", "Row Size", "Column Count"));
        for (int i = 0; i < offsets.length; ++i) {
            output.println(String.format("%-10d%10s%18s%18s%18s%18s", offsets[i], i < sprh.length ? Long.valueOf(sprh[i]) : "", i < rwlh.length ? Long.valueOf(rwlh[i]) : "", i < rrlh.length ? Long.valueOf(rrlh[i]) : "", i < ersh.length ? Long.valueOf(ersh[i]) : "", i < ecch.length ? Long.valueOf(ecch[i]) : ""));
        }
    }

    private void printEndPoints(String keySpace, String cf, String key, PrintStream output) {
        List<InetAddress> endpoints = this.probe.getEndpoints(keySpace, cf, key);
        for (InetAddress anEndpoint : endpoints) {
            output.println(anEndpoint.getHostAddress());
        }
    }

    private void printIsThriftServerRunning(PrintStream outs) {
        outs.println(this.probe.isThriftServerRunning() ? "running" : "not running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, InterruptedException, ConfigurationException, ParseException {
        parser = new PosixParser();
        cmd = null;
        try {
            cmd = new ToolCommandLine(parser.parse((Options)NodeCmd.options, args));
        }
        catch (ParseException p) {
            NodeCmd.badUse(p.getMessage());
        }
        host = cmd.getOptionValue((String)NodeCmd.HOST_OPT.left);
        port = 7199;
        portNum = cmd.getOptionValue((String)NodeCmd.PORT_OPT.left);
        if (portNum != null) {
            try {
                port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Port must be a number");
            }
        }
        username = cmd.getOptionValue((String)NodeCmd.USERNAME_OPT.left);
        password = cmd.getOptionValue((String)NodeCmd.PASSWORD_OPT.left);
        probe = null;
        try {
            probe = username == null ? new NodeProbe(host, port) : new NodeProbe(host, port, username, password);
        }
        catch (IOException ioe) {
            NodeCmd.err(ioe, "Error connection to remote JMX agent!");
        }
        try {
            command = null;
            try {
                command = cmd.getCommand();
            }
            catch (IllegalArgumentException e) {
                NodeCmd.badUse(e.getMessage());
            }
            nodeCmd = new NodeCmd(probe);
            arguments = cmd.getCommandArguments();
            switch (3.$SwitchMap$org$apache$cassandra$tools$NodeCmd$NodeCommand[command.ordinal()]) {
                case 1: {
                    nodeCmd.printRing(System.out);
                    ** break;
lbl38:
                    // 1 sources

                    break;
                }
                case 2: {
                    nodeCmd.printInfo(System.out);
                    ** break;
lbl42:
                    // 1 sources

                    break;
                }
                case 3: {
                    nodeCmd.printColumnFamilyStats(System.out);
                    ** break;
lbl46:
                    // 1 sources

                    break;
                }
                case 4: {
                    probe.decommission();
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 5: {
                    nodeCmd.printThreadPoolStats(System.out);
                    ** break;
lbl54:
                    // 1 sources

                    break;
                }
                case 6: {
                    nodeCmd.printReleaseVersion(System.out);
                    ** break;
lbl58:
                    // 1 sources

                    break;
                }
                case 7: {
                    nodeCmd.printCompactionStats(System.out);
                    ** break;
lbl62:
                    // 1 sources

                    break;
                }
                case 8: {
                    probe.stopGossiping();
                    ** break;
lbl66:
                    // 1 sources

                    break;
                }
                case 9: {
                    probe.startGossiping();
                    ** break;
lbl70:
                    // 1 sources

                    break;
                }
                case 10: {
                    probe.stopThriftServer();
                    ** break;
lbl74:
                    // 1 sources

                    break;
                }
                case 11: {
                    probe.startThriftServer();
                    ** break;
lbl78:
                    // 1 sources

                    break;
                }
                case 12: {
                    nodeCmd.printIsThriftServerRunning(System.out);
                    ** break;
lbl82:
                    // 1 sources

                    break;
                }
                case 13: {
                    try {
                        probe.drain();
                        ** break;
lbl87:
                        // 1 sources

                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured during flushing");
                        ** break;
                    }
lbl91:
                    // 1 sources

                    break;
                }
                case 14: {
                    if (arguments.length > 0) {
                        nodeCmd.printNetworkStats(InetAddress.getByName(arguments[0]), System.out);
                        ** break;
lbl96:
                        // 1 sources

                    } else {
                        nodeCmd.printNetworkStats(null, System.out);
                        ** break;
                    }
lbl99:
                    // 1 sources

                    break;
                }
                case 15: 
                case 16: {
                    tag = cmd.getOptionValue((String)NodeCmd.TAG_OPT.left);
                    NodeCmd.handleSnapshots(command, tag, arguments, probe);
                    ** break;
lbl104:
                    // 1 sources

                    break;
                }
                case 17: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing token argument for move.");
                    }
                    probe.move(arguments[0]);
                    ** break;
lbl110:
                    // 1 sources

                    break;
                }
                case 18: {
                    if (probe.isJoined()) {
                        System.err.println("This node has already joined the ring.");
                        System.exit(1);
                    }
                    probe.joinRing();
                    ** break;
lbl117:
                    // 1 sources

                    break;
                }
                case 19: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setCompactionThroughput(Integer.valueOf(arguments[0]));
                    ** break;
lbl123:
                    // 1 sources

                    break;
                }
                case 20: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setStreamThroughput(Integer.valueOf(arguments[0]));
                    ** break;
lbl129:
                    // 1 sources

                    break;
                }
                case 21: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing an argument for removetoken (either status, force, or a token)");
                        ** break;
lbl134:
                        // 1 sources

                    } else if (arguments[0].equals("status")) {
                        nodeCmd.printRemovalStatus(System.out);
                        ** break;
lbl138:
                        // 1 sources

                    } else if (arguments[0].equals("force")) {
                        nodeCmd.printRemovalStatus(System.out);
                        probe.forceRemoveCompletion();
                        ** break;
lbl143:
                        // 1 sources

                    } else {
                        probe.removeToken(arguments[0]);
                        ** break;
                    }
lbl146:
                    // 1 sources

                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    NodeCmd.optionalKSandCFs(command, cmd, arguments, probe);
                    ** break;
lbl150:
                    // 1 sources

                    break;
                }
                case 30: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("getcompactionthreshold requires ks and cf args.");
                    }
                    probe.getCompactionThreshold(System.out, arguments[0], arguments[1]);
                    ** break;
lbl156:
                    // 1 sources

                    break;
                }
                case 31: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("cfhistograms requires ks and cf args");
                    }
                    nodeCmd.printCfHistograms(arguments[0], arguments[1], System.out);
                    ** break;
lbl162:
                    // 1 sources

                    break;
                }
                case 32: {
                    if (arguments.length != 4) {
                        NodeCmd.badUse("setcachecapacity requires ks, cf, keycachecap, and rowcachecap args.");
                    }
                    probe.setCacheCapacities(arguments[0], arguments[1], Integer.parseInt(arguments[2]), Integer.parseInt(arguments[3]));
                    ** break;
lbl168:
                    // 1 sources

                    break;
                }
                case 33: {
                    if (arguments.length != 4) {
                        NodeCmd.badUse("setcompactionthreshold requires ks, cf, min, and max threshold args.");
                    }
                    minthreshold = Integer.parseInt(arguments[2]);
                    maxthreshold = Integer.parseInt(arguments[3]);
                    if (minthreshold < 0 || maxthreshold < 0) {
                        NodeCmd.badUse("Thresholds must be positive integers");
                    }
                    if (minthreshold > maxthreshold) {
                        NodeCmd.badUse("Min threshold cannot be greater than max.");
                    }
                    if (minthreshold < 2 && maxthreshold != 0) {
                        NodeCmd.badUse("Min threshold must be at least 2");
                    }
                    probe.setCompactionThreshold(arguments[0], arguments[1], minthreshold, maxthreshold);
                    ** break;
lbl182:
                    // 1 sources

                    break;
                }
                case 34: {
                    if (arguments.length != 3) {
                        NodeCmd.badUse("getendpoints requires ks, cf and key args");
                    }
                    nodeCmd.printEndPoints(arguments[0], arguments[1], arguments[2], System.out);
                    ** break;
lbl188:
                    // 1 sources

                    break;
                }
                case 35: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("load_new_sstables requires ks and cf args");
                    }
                    probe.loadNewSSTables(arguments[0], arguments[1]);
                    ** break;
lbl194:
                    // 1 sources

                    break;
                }
                case 36: {
                    nodeCmd.printGossipInfo(System.out);
                    ** break;
lbl198:
                    // 1 sources

                    break;
                }
                case 37: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing keyspace argument for describering.");
                    }
                    nodeCmd.printDescribeRing(arguments[0], System.out);
                    ** break;
lbl204:
                    // 1 sources

                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable code.");
                }
            }
        }
        finally {
            if (probe != null) {
                try {
                    probe.close();
                }
                catch (IOException ex) {}
            }
        }
        System.exit(0);
    }

    private void printDescribeRing(String keyspaceName, PrintStream out) {
        out.println("TokenRange: ");
        try {
            for (String tokenRangeString : this.probe.describeRing(keyspaceName)) {
                out.println("\t" + tokenRangeString);
            }
        }
        catch (InvalidRequestException e) {
            NodeCmd.err((Exception)((Object)e), e.getWhy());
        }
    }

    private void printGossipInfo(PrintStream out) {
        out.println(this.probe.getGossipInfo());
    }

    private static void badUse(String useStr) {
        System.err.println(useStr);
        NodeCmd.printUsage();
        System.exit(1);
    }

    private static void err(Exception e, String errStr) {
        System.err.println(errStr);
        e.printStackTrace();
        System.exit(3);
    }

    private static void complainNonzeroArgs(String[] args, NodeCommand cmd) {
        if (args.length > 0) {
            System.err.println("Too many arguments for command '" + cmd.toString() + "'.");
            NodeCmd.printUsage();
            System.exit(1);
        }
    }

    private static void handleSnapshots(NodeCommand nc, String tag, String[] cmdArgs, NodeProbe probe) throws InterruptedException, IOException {
        String[] keyspaces = Arrays.copyOfRange(cmdArgs, 0, cmdArgs.length);
        System.out.print("Requested snapshot for: ");
        if (keyspaces.length > 0) {
            for (int i = 0; i < keyspaces.length; ++i) {
                System.out.print(keyspaces[i] + " ");
            }
        } else {
            System.out.print("all keyspaces");
        }
        System.out.println();
        switch (nc) {
            case SNAPSHOT: {
                if (tag == null || tag.equals("")) {
                    tag = new Long(System.currentTimeMillis()).toString();
                }
                probe.takeSnapshot(tag, keyspaces);
                System.out.println("Snapshot directory: " + tag);
                break;
            }
            case CLEARSNAPSHOT: {
                probe.clearSnapshot(tag, keyspaces);
            }
        }
    }

    private static void optionalKSandCFs(NodeCommand nc, ToolCommandLine cmd, String[] cmdArgs, NodeProbe probe) throws InterruptedException, IOException {
        List<String> keyspaces = cmdArgs.length == 0 ? probe.getKeyspaces() : Arrays.asList(cmdArgs[0]);
        for (String keyspace : keyspaces) {
            if (probe.getKeyspaces().contains(keyspace)) continue;
            System.err.println("Keyspace [" + keyspace + "] does not exist.");
            System.exit(1);
        }
        for (String keyspace : keyspaces) {
            String[] columnFamilies = cmdArgs.length <= 1 ? new String[]{} : Arrays.copyOfRange(cmdArgs, 1, cmdArgs.length);
            switch (nc) {
                case REPAIR: {
                    if (cmd.hasOption((String)NodeCmd.PRIMARY_RANGE_OPT.left)) {
                        probe.forceTableRepairPrimaryRange(keyspace, columnFamilies);
                        break;
                    }
                    probe.forceTableRepair(keyspace, columnFamilies);
                    break;
                }
                case INVALIDATEKEYCACHE: {
                    probe.invalidateKeyCaches(keyspace, columnFamilies);
                    break;
                }
                case INVALIDATEROWCACHE: {
                    probe.invalidateRowCaches(keyspace, columnFamilies);
                    break;
                }
                case FLUSH: {
                    try {
                        probe.forceTableFlush(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured during flushing");
                    }
                    break;
                }
                case COMPACT: {
                    try {
                        probe.forceTableCompaction(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured during compaction");
                    }
                    break;
                }
                case CLEANUP: {
                    if (keyspace.equals("system")) break;
                    try {
                        probe.forceTableCleanup(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured during cleanup");
                    }
                    break;
                }
                case SCRUB: {
                    try {
                        probe.scrub(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured while scrubbing keyspace " + keyspace);
                    }
                    break;
                }
                case UPGRADESSTABLES: {
                    try {
                        probe.upgradeSSTables(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured while upgrading the sstables for keyspace " + keyspace);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable code.");
                }
            }
        }
    }

    static {
        options = new ToolOptions();
        options.addOption(HOST_OPT, true, "node hostname or ip address", true);
        options.addOption(PORT_OPT, true, "remote jmx agent port number");
        options.addOption(USERNAME_OPT, true, "remote jmx agent username");
        options.addOption(PASSWORD_OPT, true, "remote jmx agent password");
        options.addOption(TAG_OPT, true, "optional name to give a snapshot");
        options.addOption(PRIMARY_RANGE_OPT, false, "only repair the first range returned by the partitioner for the node");
    }

    private static class ToolCommandLine {
        private final CommandLine commandLine;

        public ToolCommandLine(CommandLine commands) {
            this.commandLine = commands;
        }

        public Option[] getOptions() {
            return this.commandLine.getOptions();
        }

        public boolean hasOption(String opt) {
            return this.commandLine.hasOption(opt);
        }

        public String getOptionValue(String opt) {
            return this.commandLine.getOptionValue(opt);
        }

        public NodeCommand getCommand() {
            if (this.commandLine.getArgs().length == 0) {
                throw new IllegalArgumentException("Command was not specified.");
            }
            String command = this.commandLine.getArgs()[0];
            try {
                return NodeCommand.valueOf(command.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unrecognized command: " + command);
            }
        }

        public String[] getCommandArguments() {
            List params = this.commandLine.getArgList();
            if (params.size() < 2) {
                return new String[0];
            }
            String[] toReturn = new String[params.size() - 1];
            for (int i = 1; i < params.size(); ++i) {
                toReturn[i - 1] = (String)params.get(i);
            }
            return toReturn;
        }
    }

    private static class ToolOptions
    extends Options {
        private ToolOptions() {
        }

        public void addOption(Pair<String, String> opts, boolean hasArgument, String description) {
            this.addOption(opts, hasArgument, description, false);
        }

        public void addOption(Pair<String, String> opts, boolean hasArgument, String description, boolean required) {
            this.addOption((String)opts.left, (String)opts.right, hasArgument, description, required);
        }

        public void addOption(String opt, String longOpt, boolean hasArgument, String description, boolean required) {
            Option option = new Option(opt, longOpt, hasArgument, description);
            option.setRequired(required);
            this.addOption(option);
        }
    }

    private static enum NodeCommand {
        CFHISTOGRAMS,
        CFSTATS,
        CLEANUP,
        CLEARSNAPSHOT,
        COMPACT,
        COMPACTIONSTATS,
        DECOMMISSION,
        DISABLEGOSSIP,
        DISABLETHRIFT,
        DRAIN,
        ENABLEGOSSIP,
        ENABLETHRIFT,
        FLUSH,
        GETCOMPACTIONTHRESHOLD,
        GETENDPOINTS,
        GOSSIPINFO,
        INFO,
        INVALIDATEKEYCACHE,
        INVALIDATEROWCACHE,
        JOIN,
        MOVE,
        NETSTATS,
        REFRESH,
        REMOVETOKEN,
        REPAIR,
        RING,
        SCRUB,
        SETCACHECAPACITY,
        SETCOMPACTIONTHRESHOLD,
        SETCOMPACTIONTHROUGHPUT,
        SETSTREAMTHROUGHPUT,
        SNAPSHOT,
        STATUSTHRIFT,
        TPSTATS,
        UPGRADESSTABLES,
        VERSION,
        DESCRIBERING;

    }
}

