/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.ParallelCompactionIterable;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected String compactionFileLocation = null;
    protected final int gcBefore;
    protected boolean isUserDefined;
    protected OperationType compactionType;
    protected static long totalBytesCompacted = 0L;

    public CompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) {
        super(cfs, sstables);
        this.gcBefore = gcBefore;
        this.isUserDefined = false;
        this.compactionType = OperationType.COMPACTION;
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    @Override
    public int execute(CompactionManager.CompactionExecutorStatsCollector collector) throws IOException {
        assert (this.sstables != null);
        HashSet<SSTableReader> toCompact = new HashSet<SSTableReader>(this.sstables);
        if (!this.isCompactionInteresting(toCompact)) {
            return 0;
        }
        if (this.compactionFileLocation == null) {
            this.compactionFileLocation = this.cfs.table.getDataFileLocation(this.cfs.getExpectedCompactedFileSize(toCompact), this.ensureFreeSpace());
        }
        if (this.compactionFileLocation == null && this.partialCompactionsAcceptable()) {
            while (this.compactionFileLocation == null && toCompact.size() > 1) {
                logger.warn("insufficient space to compact all requested files " + StringUtils.join(toCompact, (String)", "));
                toCompact.remove(this.cfs.getMaxSizeFile(toCompact));
                this.compactionFileLocation = this.cfs.table.getDataFileLocation(this.cfs.getExpectedCompactedFileSize(toCompact), this.ensureFreeSpace());
            }
            if (this.compactionFileLocation == null) {
                logger.warn("insufficient space to compact even the two smallest files, aborting");
                return 0;
            }
        }
        assert (this.compactionFileLocation != null);
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            this.cfs.snapshotWithoutFlush(System.currentTimeMillis() + "-" + "compact-" + this.cfs.columnFamily);
        }
        for (SSTableReader sstable : toCompact) {
            assert (sstable.descriptor.cfname.equals(this.cfs.columnFamily));
        }
        CompactionController controller = new CompactionController(this.cfs, toCompact, this.gcBefore, this.isUserDefined);
        logger.info("Compacting {}", toCompact);
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        long estimatedTotalKeys = Math.max((long)DatabaseDescriptor.getIndexInterval().intValue(), SSTableReader.getApproximateKeyCount(toCompact));
        long estimatedSSTables = Math.max(1L, SSTable.getTotalBytes(toCompact) / this.cfs.getCompactionStrategy().getMaxSSTableSize());
        long keysPerSSTable = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
        if (logger.isDebugEnabled()) {
            logger.debug("Expected bloom filter size : " + keysPerSSTable);
        }
        AbstractCompactionIterable ci = DatabaseDescriptor.isMultithreadedCompaction() ? new ParallelCompactionIterable(this.compactionType, toCompact, controller) : new CompactionIterable(this.compactionType, toCompact, controller);
        Iterator iter = ci.iterator();
        UnmodifiableIterator nni = Iterators.filter((Iterator)iter, (Predicate)Predicates.notNull());
        HashMap cachedKeys = new HashMap();
        HashMap cachedKeyMap = new HashMap();
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
        ArrayList<SSTableWriter> writers = new ArrayList<SSTableWriter>();
        if (collector != null) {
            collector.beginCompaction(ci);
        }
        try {
            if (!nni.hasNext()) {
                this.cfs.markCompacted(toCompact, this.compactionType);
                int n = 0;
                return n;
            }
            SSTableWriter writer = this.cfs.createCompactionWriter(keysPerSSTable, this.compactionFileLocation, toCompact);
            writers.add(writer);
            while (nni.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                if (row.isEmpty()) continue;
                long position = writer.append(row);
                ++totalkeysWritten;
                if (DatabaseDescriptor.getPreheatKeyCache()) {
                    for (SSTableReader sstable : toCompact) {
                        if (sstable.getCachedPosition(row.key, false) == null) continue;
                        cachedKeys.put(row.key, position);
                        break;
                    }
                }
                if (nni.hasNext() && !this.newSSTableSegmentThresholdReached(writer, position)) continue;
                SSTableReader toIndex = writer.closeAndOpenReader(CompactionTask.getMaxDataAge(toCompact));
                cachedKeyMap.put(toIndex, cachedKeys);
                sstables.add(toIndex);
                if (!nni.hasNext()) continue;
                writer = this.cfs.createCompactionWriter(keysPerSSTable, this.compactionFileLocation, toCompact);
                writers.add(writer);
                cachedKeys = new HashMap();
            }
        }
        catch (Exception e) {
            for (SSTableWriter writer : writers) {
                writer.abort();
            }
            throw FBUtilities.unchecked(e);
        }
        finally {
            iter.close();
            if (collector != null) {
                collector.finishCompaction(ci);
            }
        }
        this.cfs.replaceCompactedSSTables(toCompact, sstables, this.compactionType);
        for (Map.Entry ssTableReaderMapEntry : cachedKeyMap.entrySet()) {
            SSTableReader key = (SSTableReader)ssTableReaderMapEntry.getKey();
            for (Map.Entry entry : ((Map)ssTableReaderMapEntry.getValue()).entrySet()) {
                key.cacheKey((DecoratedKey)entry.getKey(), (Long)entry.getValue());
            }
        }
        long dTime = System.currentTimeMillis() - startTime;
        long startsize = SSTable.getTotalBytes(toCompact);
        long endsize = SSTable.getTotalBytes(sstables);
        double ratio = (double)endsize / (double)startsize;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (SSTableReader reader : sstables) {
            builder.append(reader.getFilename()).append(",");
        }
        builder.append("]");
        double mbps = dTime > 0L ? (double)endsize / 1048576.0 / ((double)dTime / 1000.0) : 0.0;
        logger.info(String.format("Compacted to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys at %fMB/s.  Time: %,dms.", builder.toString(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, mbps, dTime));
        logger.debug(String.format("CF Total Bytes Compacted: %,d", CompactionTask.addToTotalBytesCompacted(endsize)));
        return toCompact.size();
    }

    protected boolean partialCompactionsAcceptable() {
        return !this.isUserDefined;
    }

    protected boolean ensureFreeSpace() {
        return !this.isUserDefined;
    }

    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer, long position) {
        return false;
    }

    protected boolean isCompactionInteresting(Set<SSTableReader> toCompact) {
        if (this.isUserDefined || toCompact.size() >= 2) {
            return true;
        }
        logger.info(String.format("Nothing to compact in %s.  Use forceUserDefinedCompaction if you wish to force compaction of single sstables (e.g. for tombstone collection)", this.cfs.getColumnFamilyName()));
        return false;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }

    public CompactionTask compactionFileLocation(String compactionFileLocation) {
        this.compactionFileLocation = compactionFileLocation;
        return this;
    }

    public CompactionTask isUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
        return this;
    }

    public CompactionTask setCompactionType(OperationType compactionType) {
        this.compactionType = compactionType;
        return this;
    }
}

