/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.AbstractColumnContainer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.ThreadSafeSortedColumns;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.HeapAllocator;

public class ColumnFamily
extends AbstractColumnContainer {
    private static ColumnFamilySerializer serializer = new ColumnFamilySerializer();
    private final CFMetaData cfm;

    public static ColumnFamilySerializer serializer() {
        return serializer;
    }

    public static ColumnFamily create(Integer cfId) {
        return ColumnFamily.create(Schema.instance.getCFMetaData(cfId));
    }

    public static ColumnFamily create(Integer cfId, ISortedColumns.Factory factory) {
        return ColumnFamily.create(Schema.instance.getCFMetaData(cfId), factory);
    }

    public static ColumnFamily create(String tableName, String cfName) {
        return ColumnFamily.create(Schema.instance.getCFMetaData(tableName, cfName));
    }

    public static ColumnFamily create(CFMetaData cfm) {
        return ColumnFamily.create(cfm, ThreadSafeSortedColumns.factory());
    }

    public static ColumnFamily create(CFMetaData cfm, ISortedColumns.Factory factory) {
        return ColumnFamily.create(cfm, factory, false);
    }

    public static ColumnFamily create(CFMetaData cfm, ISortedColumns.Factory factory, boolean reversedInsertOrder) {
        return new ColumnFamily(cfm, factory.create(cfm.comparator, reversedInsertOrder));
    }

    private ColumnFamily(CFMetaData cfm, ISortedColumns map) {
        super(map);
        assert (cfm != null);
        this.cfm = cfm;
    }

    public ColumnFamily cloneMeShallow(ISortedColumns.Factory factory, boolean reversedInsertOrder) {
        ColumnFamily cf = ColumnFamily.create(this.cfm, factory, reversedInsertOrder);
        cf.deletionInfo.set(this.deletionInfo.get());
        return cf;
    }

    public ColumnFamily cloneMeShallow() {
        return this.cloneMeShallow(this.columns.getFactory(), this.columns.isInsertReversed());
    }

    public AbstractType getSubComparator() {
        IColumnSerializer s = this.getColumnSerializer();
        return s instanceof SuperColumnSerializer ? ((SuperColumnSerializer)s).getComparator() : null;
    }

    public ColumnFamilyType getType() {
        return this.cfm.cfType;
    }

    public ColumnFamily cloneMe() {
        ColumnFamily cf = new ColumnFamily(this.cfm, this.columns.cloneMe());
        cf.deletionInfo.set(this.deletionInfo.get());
        return cf;
    }

    public Integer id() {
        return this.cfm.cfId;
    }

    public CFMetaData metadata() {
        return this.cfm;
    }

    public IColumnSerializer getColumnSerializer() {
        return this.cfm.getColumnSerializer();
    }

    public boolean isSuper() {
        return this.getType() == ColumnFamilyType.Super;
    }

    public void addAllWithSCCopy(ColumnFamily cf, Allocator allocator) {
        if (cf.isSuper()) {
            for (IColumn c : cf) {
                this.columns.addColumn(((SuperColumn)c).cloneMeShallow(), allocator);
            }
            this.delete(cf);
        } else {
            this.addAll(cf, allocator);
        }
    }

    public void addColumn(QueryPath path, ByteBuffer value, long timestamp) {
        this.addColumn(path, value, timestamp, 0);
    }

    public void addColumn(QueryPath path, ByteBuffer value, long timestamp, int timeToLive) {
        assert (path.columnName != null) : path;
        assert (!this.metadata().getDefaultValidator().isCommutative());
        Column column = timeToLive > 0 ? new ExpiringColumn(path.columnName, value, timestamp, timeToLive) : new Column(path.columnName, value, timestamp);
        this.addColumn(path.superColumnName, column);
    }

    public void addCounter(QueryPath path, long value) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new CounterUpdateColumn(path.columnName, value, System.currentTimeMillis()));
    }

    public void addTombstone(QueryPath path, ByteBuffer localDeletionTime, long timestamp) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new DeletedColumn(path.columnName, localDeletionTime, timestamp));
    }

    public void addTombstone(QueryPath path, int localDeletionTime, long timestamp) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new DeletedColumn(path.columnName, localDeletionTime, timestamp));
    }

    public void addTombstone(ByteBuffer name, int localDeletionTime, long timestamp) {
        this.addColumn(null, new DeletedColumn(name, localDeletionTime, timestamp));
    }

    public void addColumn(ByteBuffer superColumnName, Column column) {
        IColumn c;
        if (superColumnName == null) {
            c = column;
        } else {
            assert (this.isSuper());
            c = new SuperColumn(superColumnName, this.getSubComparator());
            c.addColumn(column);
        }
        this.addColumn(c);
    }

    public void clear() {
        this.columns.clear();
    }

    public ColumnFamily diff(ColumnFamily cfComposite) {
        assert (cfComposite.id().equals(this.id()));
        ColumnFamily cfDiff = ColumnFamily.create(this.cfm);
        if (cfComposite.getMarkedForDeleteAt() > this.getMarkedForDeleteAt()) {
            cfDiff.delete(cfComposite.getLocalDeletionTime(), cfComposite.getMarkedForDeleteAt());
        }
        for (IColumn columnExternal : cfComposite) {
            ByteBuffer cName = columnExternal.name();
            IColumn columnInternal = this.columns.getColumn(cName);
            if (columnInternal == null) {
                cfDiff.addColumn(columnExternal);
                continue;
            }
            IColumn columnDiff = columnInternal.diff(columnExternal);
            if (columnDiff == null) continue;
            cfDiff.addColumn(columnDiff);
        }
        if (!cfDiff.isEmpty() || cfDiff.isMarkedForDelete()) {
            return cfDiff;
        }
        return null;
    }

    int size() {
        int size = 0;
        for (IColumn column : this.columns) {
            size += column.size();
        }
        return size;
    }

    public long maxTimestamp() {
        long maxTimestamp = Long.MIN_VALUE;
        for (IColumn column : this.columns) {
            maxTimestamp = Math.max(maxTimestamp, column.maxTimestamp());
        }
        return maxTimestamp;
    }

    public int hashCode() {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object o) {
        throw new RuntimeException("Not implemented.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnFamily(");
        CFMetaData cfm = this.metadata();
        sb.append(cfm == null ? "<anonymous>" : cfm.cfName);
        if (this.isMarkedForDelete()) {
            sb.append(" -deleted at ").append(this.getMarkedForDeleteAt()).append("-");
        }
        sb.append(" [").append(this.getComparator().getColumnsString(this.getSortedColumns())).append("])");
        return sb.toString();
    }

    public static ByteBuffer digest(ColumnFamily cf) {
        MessageDigest digest = FBUtilities.threadLocalMD5Digest();
        if (cf != null) {
            cf.updateDigest(digest);
        }
        return ByteBuffer.wrap(digest.digest());
    }

    public void updateDigest(MessageDigest digest) {
        for (IColumn column : this.columns) {
            column.updateDigest(digest);
        }
    }

    public static AbstractType getComparatorFor(String table, String columnFamilyName, ByteBuffer superColumnName) {
        return superColumnName == null ? Schema.instance.getComparator(table, columnFamilyName) : Schema.instance.getSubComparator(table, columnFamilyName);
    }

    public static ColumnFamily diff(ColumnFamily cf1, ColumnFamily cf2) {
        if (cf1 == null) {
            return cf2;
        }
        return cf1.diff(cf2);
    }

    public void resolve(ColumnFamily cf) {
        this.resolve(cf, HeapAllocator.instance);
    }

    public void resolve(ColumnFamily cf, Allocator allocator) {
        if (cf == null) {
            return;
        }
        this.addAll(cf, allocator);
    }

    public long serializedSize() {
        return 5L + this.serializedSizeForSSTable();
    }

    public long serializedSizeForSSTable() {
        int size = 16;
        for (IColumn column : this.columns) {
            size += column.serializedSize();
        }
        return size;
    }

    public void validateColumnFields() throws MarshalException {
        CFMetaData metadata = this.metadata();
        for (IColumn column : this) {
            column.validateFields(metadata);
        }
    }
}

