/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.util.List;
import org.apache.cassandra.cql.Attributes;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;

public abstract class AbstractModification {
    public static final ConsistencyLevel defaultConsistency = ConsistencyLevel.ONE;
    protected final String keyspace;
    protected final String columnFamily;
    protected final ConsistencyLevel cLevel;
    protected final Long timestamp;
    protected final int timeToLive;
    protected final String keyName;

    public AbstractModification(String keyspace, String columnFamily, String keyAlias, Attributes attrs) {
        this(keyspace, columnFamily, keyAlias, attrs.getConsistencyLevel(), attrs.getTimestamp(), attrs.getTimeToLive());
    }

    public AbstractModification(String keyspace, String columnFamily, String keyAlias, ConsistencyLevel cLevel, Long timestamp, int timeToLive) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.cLevel = cLevel;
        this.timestamp = timestamp;
        this.timeToLive = timeToLive;
        this.keyName = keyAlias.toUpperCase();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.cLevel != null ? this.cLevel : defaultConsistency;
    }

    public boolean isSetConsistencyLevel() {
        return this.cLevel != null;
    }

    public long getTimestamp(ClientState clientState) {
        return this.timestamp == null ? clientState.getTimestamp() : this.timestamp.longValue();
    }

    public boolean isSetTimestamp() {
        return this.timestamp != null;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public abstract List<IMutation> prepareRowMutations(String var1, ClientState var2) throws InvalidRequestException;

    public abstract List<IMutation> prepareRowMutations(String var1, ClientState var2, Long var3) throws InvalidRequestException;
}

