/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.db.migration.avro.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnDefinition {
    public final ByteBuffer name;
    private AbstractType validator;
    private org.apache.cassandra.thrift.IndexType index_type;
    private Map<String, String> index_options;
    private String index_name;

    public ColumnDefinition(ByteBuffer name, AbstractType validator, org.apache.cassandra.thrift.IndexType index_type, Map<String, String> index_options, String index_name) throws ConfigurationException {
        this.name = name;
        this.index_name = index_name;
        this.validator = validator;
        this.setIndexType(index_type, index_options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        if (this.index_name != null ? !this.index_name.equals(that.index_name) : that.index_name != null) {
            return false;
        }
        if (this.index_type != that.index_type) {
            return false;
        }
        if (this.index_options != null ? !((Object)this.index_options).equals(that.index_options) : that.index_options != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.validator == null ? that.validator != null : !this.validator.equals(that.validator));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.validator != null ? this.validator.hashCode() : 0);
        result = 31 * result + (this.index_type != null ? this.index_type.hashCode() : 0);
        result = 31 * result + (this.index_options != null ? ((Object)this.index_options).hashCode() : 0);
        result = 31 * result + (this.index_name != null ? this.index_name.hashCode() : 0);
        return result;
    }

    public ColumnDef toAvro() {
        ColumnDef cd = new ColumnDef();
        cd.name = ByteBufferUtil.clone(this.name);
        cd.validation_class = new Utf8(this.validator.toString());
        cd.index_type = this.index_type == null ? null : IndexType.valueOf(this.index_type.name());
        cd.index_name = this.index_name == null ? null : new Utf8(this.index_name);
        cd.index_options = ColumnDefinition.getCharSequenceMap(this.index_options);
        return cd;
    }

    public static ColumnDefinition fromAvro(ColumnDef cd) {
        org.apache.cassandra.thrift.IndexType index_type = cd.index_type == null ? null : Enum.valueOf(org.apache.cassandra.thrift.IndexType.class, cd.index_type.name());
        String index_name = cd.index_name == null ? null : ((Object)cd.index_name).toString();
        try {
            AbstractType validatorType = TypeParser.parse(cd.validation_class);
            return new ColumnDefinition(ByteBufferUtil.clone(cd.name), validatorType, index_type, ColumnDefinition.getStringMap(cd.index_options), index_name);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ColumnDefinition fromThrift(org.apache.cassandra.thrift.ColumnDef thriftColumnDef) throws ConfigurationException {
        return new ColumnDefinition(ByteBufferUtil.clone(thriftColumnDef.name), TypeParser.parse(thriftColumnDef.validation_class), thriftColumnDef.index_type, thriftColumnDef.index_options, thriftColumnDef.index_name);
    }

    public static Map<ByteBuffer, ColumnDefinition> fromThrift(List<org.apache.cassandra.thrift.ColumnDef> thriftDefs) throws ConfigurationException {
        if (thriftDefs == null) {
            return new HashMap<ByteBuffer, ColumnDefinition>();
        }
        TreeMap<ByteBuffer, ColumnDefinition> cds = new TreeMap<ByteBuffer, ColumnDefinition>();
        for (org.apache.cassandra.thrift.ColumnDef thriftColumnDef : thriftDefs) {
            cds.put(ByteBufferUtil.clone(thriftColumnDef.name), ColumnDefinition.fromThrift(thriftColumnDef));
        }
        return cds;
    }

    public String toString() {
        return "ColumnDefinition{name=" + ByteBufferUtil.bytesToHex(this.name) + ", validator=" + this.validator + ", index_type=" + this.index_type + ", index_name='" + this.index_name + '\'' + '}';
    }

    public String getIndexName() {
        return this.index_name;
    }

    public void setIndexName(String s) {
        this.index_name = s;
    }

    public void setIndexType(org.apache.cassandra.thrift.IndexType index_type, Map<String, String> index_options) throws ConfigurationException {
        this.index_type = index_type;
        this.index_options = index_options;
    }

    public org.apache.cassandra.thrift.IndexType getIndexType() {
        return this.index_type;
    }

    public Map<String, String> getIndexOptions() {
        return this.index_options;
    }

    public AbstractType getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractType validator) {
        this.validator = validator;
    }

    public static Map<String, String> getStringMap(Map<CharSequence, CharSequence> charMap) {
        if (charMap == null) {
            return null;
        }
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charMap.entrySet()) {
            stringMap.put(((Object)entry.getKey()).toString(), ((Object)entry.getValue()).toString());
        }
        return stringMap;
    }

    private static Map<CharSequence, CharSequence> getCharSequenceMap(Map<String, String> stringMap) {
        if (stringMap == null) {
            return null;
        }
        HashMap<CharSequence, CharSequence> charMap = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            charMap.put((CharSequence)new Utf8(entry.getKey()), (CharSequence)new Utf8(entry.getValue()));
        }
        return charMap;
    }
}

